/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.ldap;

import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.base.jndi.JndiUtils;
import io.trino.plugin.base.ldap.LdapClient;
import io.trino.plugin.base.ldap.LdapClientConfig;
import io.trino.plugin.base.ldap.LdapQuery;
import io.trino.plugin.base.ldap.LdapSslSocketFactory;
import io.trino.plugin.base.ssl.SslUtils;
import io.trino.spi.security.AccessDeniedException;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.net.ssl.SSLContext;

public class JdkLdapClient
implements LdapClient {
    private static final Logger log = Logger.get(JdkLdapClient.class);
    private final Map<String, String> basicEnvironment;
    private final Optional<SSLContext> sslContext;

    @Inject
    public JdkLdapClient(LdapClientConfig ldapConfig) {
        String ldapUrl = Objects.requireNonNull(ldapConfig.getLdapUrl(), "ldapUrl is null");
        if (ldapUrl.startsWith("ldap://")) {
            log.warn("Passwords will be sent in the clear to the LDAP server. Please consider using SSL to connect.");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"java.naming.factory.initial", (Object)"com.sun.jndi.ldap.LdapCtxFactory").put((Object)"java.naming.provider.url", (Object)ldapUrl).put((Object)"java.naming.referral", (Object)(ldapConfig.isIgnoreReferrals() ? "ignore" : "follow"));
        ldapConfig.getLdapConnectionTimeout().map(Duration::toMillis).map(String::valueOf).ifPresent(timeout -> builder.put((Object)"com.sun.jndi.ldap.connect.timeout", timeout));
        ldapConfig.getLdapReadTimeout().map(Duration::toMillis).map(String::valueOf).ifPresent(timeout -> builder.put((Object)"com.sun.jndi.ldap.read.timeout", timeout));
        this.basicEnvironment = builder.buildOrThrow();
        this.sslContext = JdkLdapClient.createSslContext(ldapConfig.getKeystorePath(), ldapConfig.getKeystorePassword(), ldapConfig.getTrustStorePath(), ldapConfig.getTruststorePassword());
    }

    @Override
    public <T> T processLdapContext(String userName, String password, LdapClient.LdapContextProcessor<T> contextProcessor) throws NamingException {
        try (CloseableContext context = this.createUserDirContext(userName, password);){
            T t = contextProcessor.process(context.context);
            return t;
        }
    }

    @Override
    public <T> T executeLdapQuery(String userName, String password, LdapQuery ldapQuery, LdapClient.LdapSearchResultProcessor<T> resultProcessor) throws NamingException {
        try (CloseableContext context = this.createUserDirContext(userName, password);){
            T t;
            block12: {
                CloseableSearchResults search = JdkLdapClient.searchContext(ldapQuery, context);
                try {
                    t = resultProcessor.process(search.searchResults);
                    if (search == null) break block12;
                }
                catch (Throwable throwable) {
                    if (search != null) {
                        try {
                            search.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                search.close();
            }
            return t;
        }
    }

    private static CloseableSearchResults searchContext(LdapQuery ldapQuery, CloseableContext context) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(ldapQuery.getAttributes());
        return new CloseableSearchResults(context.search(ldapQuery.getSearchBase(), ldapQuery.getSearchFilter(), searchControls));
    }

    private CloseableContext createUserDirContext(String userDistinguishedName, String password) throws NamingException {
        Map<String, String> environment = this.createEnvironment(userDistinguishedName, password);
        try {
            DirContext context = JndiUtils.createDirContext(environment);
            log.debug("Password validation successful for user DN [%s]", new Object[]{userDistinguishedName});
            return new CloseableContext(context);
        }
        catch (AuthenticationException e) {
            log.debug("Password validation failed for user DN [%s]: %s", new Object[]{userDistinguishedName, e.getMessage()});
            throw new AccessDeniedException("Invalid credentials");
        }
    }

    private Map<String, String> createEnvironment(String userDistinguishedName, String password) {
        ImmutableMap.Builder environment = ImmutableMap.builder().putAll(this.basicEnvironment).put((Object)"java.naming.security.authentication", (Object)"simple").put((Object)"java.naming.security.principal", (Object)userDistinguishedName).put((Object)"java.naming.security.credentials", (Object)password);
        this.sslContext.ifPresent(context -> {
            LdapSslSocketFactory.setSslContextForCurrentThread(context);
            environment.put((Object)"java.naming.ldap.factory.socket", (Object)LdapSslSocketFactory.class.getName());
        });
        return environment.buildOrThrow();
    }

    private static Optional<SSLContext> createSslContext(Optional<File> keyStorePath, Optional<String> keyStorePassword, Optional<File> trustStorePath, Optional<String> trustStorePassword) {
        if (keyStorePath.isEmpty() && trustStorePath.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(SslUtils.createSSLContext(keyStorePath, keyStorePassword, trustStorePath, trustStorePassword));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CloseableSearchResults
    implements AutoCloseable {
        private final NamingEnumeration<SearchResult> searchResults;

        public CloseableSearchResults(NamingEnumeration<SearchResult> searchResults) {
            this.searchResults = Objects.requireNonNull(searchResults, "searchResults is null");
        }

        public NamingEnumeration<SearchResult> getSearchResult() throws NamingException {
            return this.searchResults;
        }

        @Override
        public void close() throws NamingException {
            this.searchResults.close();
        }
    }

    private static class CloseableContext
    implements AutoCloseable {
        private final DirContext context;

        public CloseableContext(DirContext context) {
            this.context = Objects.requireNonNull(context, "context is null");
        }

        public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls searchControls) throws NamingException {
            return this.context.search(name, filter, searchControls);
        }

        @Override
        public void close() throws NamingException {
            this.context.close();
        }
    }
}

