/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class ClassLoaderSafeConnectorAccessControl
implements ConnectorAccessControl {
    private final ConnectorAccessControl delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorAccessControl(@ForClassLoaderSafe ConnectorAccessControl delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanCreateSchema(context, schemaName);
        }
    }

    public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDropSchema(context, schemaName);
        }
    }

    public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRenameSchema(context, schemaName, newSchemaName);
        }
    }

    public void checkCanSetSchemaAuthorization(ConnectorSecurityContext context, String schemaName, TrinoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetSchemaAuthorization(context, schemaName, principal);
        }
    }

    public void checkCanShowSchemas(ConnectorSecurityContext context) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowSchemas(context);
        }
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.filterSchemas(context, schemaNames);
            return set;
        }
    }

    public void checkCanShowCreateSchema(ConnectorSecurityContext context, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowCreateSchema(context, schemaName);
        }
    }

    public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowCreateTable(context, tableName);
        }
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Object> properties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanCreateTable(context, tableName, properties);
        }
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDropTable(context, tableName);
        }
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRenameTable(context, tableName, newTableName);
        }
    }

    public void checkCanSetTableProperties(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Optional<Object>> properties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetTableProperties(context, tableName, properties);
        }
    }

    public void checkCanSetTableComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetTableComment(context, tableName);
        }
    }

    public void checkCanSetColumnComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetColumnComment(context, tableName);
        }
    }

    public void checkCanShowTables(ConnectorSecurityContext context, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowTables(context, schemaName);
        }
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.filterTables(context, tableNames);
            return set;
        }
    }

    public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowColumns(context, tableName);
        }
    }

    public Set<String> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.filterColumns(context, tableName, columns);
            return set;
        }
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanAddColumn(context, tableName);
        }
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDropColumn(context, tableName);
        }
    }

    public void checkCanSetTableAuthorization(ConnectorSecurityContext context, SchemaTableName tableName, TrinoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetTableAuthorization(context, tableName, principal);
        }
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRenameColumn(context, tableName);
        }
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSelectFromColumns(context, tableName, columnNames);
        }
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanInsertIntoTable(context, tableName);
        }
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDeleteFromTable(context, tableName);
        }
    }

    public void checkCanTruncateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanTruncateTable(context, tableName);
        }
    }

    public void checkCanUpdateTableColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> updatedColumnNames) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanUpdateTableColumns(context, tableName, updatedColumnNames);
        }
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanCreateView(context, viewName);
        }
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRenameView(context, viewName, newViewName);
        }
    }

    public void checkCanSetViewAuthorization(ConnectorSecurityContext context, SchemaTableName viewName, TrinoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetViewAuthorization(context, viewName, principal);
        }
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDropView(context, viewName);
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames);
        }
    }

    public void checkCanCreateMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Object> properties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanCreateMaterializedView(context, materializedViewName, properties);
        }
    }

    public void checkCanRefreshMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRefreshMaterializedView(context, materializedViewName);
        }
    }

    public void checkCanDropMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDropMaterializedView(context, materializedViewName);
        }
    }

    public void checkCanRenameMaterializedView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRenameMaterializedView(context, viewName, newViewName);
        }
    }

    public void checkCanSetMaterializedViewProperties(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Optional<Object>> properties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetMaterializedViewProperties(context, materializedViewName, properties);
        }
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetCatalogSessionProperty(context, propertyName);
        }
    }

    public void checkCanGrantSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanGrantSchemaPrivilege(context, privilege, schemaName, grantee, grantOption);
        }
    }

    public void checkCanDenyTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDenyTablePrivilege(context, privilege, tableName, grantee);
        }
    }

    public void checkCanDenySchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDenySchemaPrivilege(context, privilege, schemaName, grantee);
        }
    }

    public void checkCanRevokeSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal revokee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRevokeSchemaPrivilege(context, privilege, schemaName, revokee, grantOption);
        }
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanGrantTablePrivilege(context, privilege, tableName, grantee, grantOption);
        }
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal revokee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRevokeTablePrivilege(context, privilege, tableName, revokee, grantOption);
        }
    }

    public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanCreateRole(context, role, grantor);
        }
    }

    public void checkCanDropRole(ConnectorSecurityContext context, String role) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDropRole(context, role);
        }
    }

    public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanGrantRoles(context, roles, grantees, adminOption, grantor);
        }
    }

    public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRevokeRoles(context, roles, grantees, adminOption, grantor);
        }
    }

    public void checkCanSetRole(ConnectorSecurityContext context, String role) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetRole(context, role);
        }
    }

    public void checkCanShowRoleAuthorizationDescriptors(ConnectorSecurityContext context) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowRoleAuthorizationDescriptors(context);
        }
    }

    public void checkCanShowRoles(ConnectorSecurityContext context) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowRoles(context);
        }
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowCurrentRoles(context);
        }
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowRoleGrants(context);
        }
    }

    public void checkCanExecuteProcedure(ConnectorSecurityContext context, SchemaRoutineName procedure) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanExecuteProcedure(context, procedure);
        }
    }

    public void checkCanExecuteTableProcedure(ConnectorSecurityContext context, SchemaTableName tableName, String procedure) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanExecuteTableProcedure(context, tableName, procedure);
        }
    }

    public List<ViewExpression> getRowFilters(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.getRowFilters(context, tableName);
            return list;
        }
    }

    public List<ViewExpression> getColumnMasks(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.getColumnMasks(context, tableName, columnName, type);
            return list;
        }
    }
}

