/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.aggregation;

import com.google.common.base.Verify;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public interface AggregateFunctionRule<Result> {
    public Pattern<AggregateFunction> getPattern();

    public Optional<Result> rewrite(AggregateFunction var1, Captures var2, RewriteContext var3);

    public static interface RewriteContext {
        default public ColumnHandle getAssignment(String name) {
            Objects.requireNonNull(name, "name is null");
            ColumnHandle columnHandle = this.getAssignments().get(name);
            Verify.verifyNotNull((Object)columnHandle, (String)"No assignment for %s", (Object[])new Object[]{name});
            return columnHandle;
        }

        public Map<String, ColumnHandle> getAssignments();

        public Function<String, String> getIdentifierQuote();

        public ConnectorSession getSession();
    }
}

