/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingSystemAccessControl
implements SystemAccessControl {
    public static SystemAccessControl of(final Supplier<SystemAccessControl> systemAccessControlSupplier) {
        Objects.requireNonNull(systemAccessControlSupplier, "systemAccessControlSupplier is null");
        return new ForwardingSystemAccessControl(){

            @Override
            protected SystemAccessControl delegate() {
                return (SystemAccessControl)systemAccessControlSupplier.get();
            }
        };
    }

    protected abstract SystemAccessControl delegate();

    public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
        this.delegate().checkCanImpersonateUser(context, userName);
    }

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        this.delegate().checkCanSetUser(principal, userName);
    }

    public void checkCanReadSystemInformation(SystemSecurityContext context) {
        this.delegate().checkCanReadSystemInformation(context);
    }

    public void checkCanWriteSystemInformation(SystemSecurityContext context) {
        this.delegate().checkCanWriteSystemInformation(context);
    }

    public void checkCanExecuteQuery(SystemSecurityContext context) {
        this.delegate().checkCanExecuteQuery(context);
    }

    public void checkCanViewQueryOwnedBy(SystemSecurityContext context, Identity queryOwner) {
        this.delegate().checkCanViewQueryOwnedBy(context, queryOwner);
    }

    public void checkCanViewQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        this.delegate().checkCanViewQueryOwnedBy(context, queryOwner);
    }

    public Collection<Identity> filterViewQueryOwnedBy(SystemSecurityContext context, Collection<Identity> queryOwners) {
        return this.delegate().filterViewQueryOwnedBy(context, queryOwners);
    }

    public Set<String> filterViewQueryOwnedBy(SystemSecurityContext context, Set<String> queryOwners) {
        return this.delegate().filterViewQueryOwnedBy(context, queryOwners);
    }

    public void checkCanKillQueryOwnedBy(SystemSecurityContext context, Identity queryOwner) {
        this.delegate().checkCanKillQueryOwnedBy(context, queryOwner);
    }

    public void checkCanKillQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        this.delegate().checkCanKillQueryOwnedBy(context, queryOwner);
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
        this.delegate().checkCanSetSystemSessionProperty(context, propertyName);
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        this.delegate().checkCanAccessCatalog(context, catalogName);
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        return this.delegate().filterCatalogs(context, catalogs);
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanCreateSchema(context, schema);
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanDropSchema(context, schema);
    }

    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        this.delegate().checkCanRenameSchema(context, schema, newSchemaName);
    }

    public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, TrinoPrincipal principal) {
        this.delegate().checkCanSetSchemaAuthorization(context, schema, principal);
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        this.delegate().checkCanShowSchemas(context, catalogName);
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        return this.delegate().filterSchemas(context, catalogName, schemaNames);
    }

    public void checkCanShowCreateSchema(SystemSecurityContext context, CatalogSchemaName schemaName) {
        this.delegate().checkCanShowCreateSchema(context, schemaName);
    }

    public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanShowCreateTable(context, table);
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Object> properties) {
        this.delegate().checkCanCreateTable(context, table, properties);
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDropTable(context, table);
    }

    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        this.delegate().checkCanRenameTable(context, table, newTable);
    }

    public void checkCanSetTableProperties(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Optional<Object>> properties) {
        this.delegate().checkCanSetTableProperties(context, table, properties);
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanSetTableComment(context, table);
    }

    public void checkCanSetColumnComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanSetColumnComment(context, table);
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        this.delegate().checkCanShowTables(context, schema);
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(context, catalogName, tableNames);
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        this.delegate().checkCanShowColumns(context, tableName);
    }

    public Set<String> filterColumns(SystemSecurityContext context, CatalogSchemaTableName tableName, Set<String> columns) {
        return this.delegate().filterColumns(context, tableName, columns);
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanAddColumn(context, table);
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDropColumn(context, table);
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanRenameColumn(context, table);
    }

    public void checkCanSetTableAuthorization(SystemSecurityContext context, CatalogSchemaTableName table, TrinoPrincipal principal) {
        this.delegate().checkCanSetTableAuthorization(context, table, principal);
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanSelectFromColumns(context, table, columns);
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanInsertIntoTable(context, table);
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanDeleteFromTable(context, table);
    }

    public void checkCanTruncateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.delegate().checkCanTruncateTable(context, table);
    }

    public void checkCanUpdateTableColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> updatedColumnNames) {
        this.delegate().checkCanUpdateTableColumns(context, table, updatedColumnNames);
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        this.delegate().checkCanCreateView(context, view);
    }

    public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        this.delegate().checkCanRenameView(context, view, newView);
    }

    public void checkCanSetViewAuthorization(SystemSecurityContext context, CatalogSchemaTableName view, TrinoPrincipal principal) {
        this.delegate().checkCanSetViewAuthorization(context, view, principal);
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        this.delegate().checkCanDropView(context, view);
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(context, table, columns);
    }

    public void checkCanCreateMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Object> properties) {
        this.delegate().checkCanCreateMaterializedView(context, materializedView, properties);
    }

    public void checkCanRefreshMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        this.delegate().checkCanRefreshMaterializedView(context, materializedView);
    }

    public void checkCanDropMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        this.delegate().checkCanDropMaterializedView(context, materializedView);
    }

    public void checkCanRenameMaterializedView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        this.delegate().checkCanRenameMaterializedView(context, view, newView);
    }

    public void checkCanSetMaterializedViewProperties(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Optional<Object>> properties) {
        this.delegate().checkCanSetMaterializedViewProperties(context, materializedView, properties);
    }

    public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String functionName, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantExecuteFunctionPrivilege(context, functionName, grantee, grantOption);
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(context, catalogName, propertyName);
    }

    public void checkCanGrantSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantSchemaPrivilege(context, privilege, schema, grantee, grantOption);
    }

    public void checkCanDenySchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee) {
        this.delegate().checkCanDenySchemaPrivilege(context, privilege, schema, grantee);
    }

    public void checkCanRevokeSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal revokee, boolean grantOption) {
        this.delegate().checkCanRevokeSchemaPrivilege(context, privilege, schema, revokee, grantOption);
    }

    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantTablePrivilege(context, privilege, table, grantee, grantOption);
    }

    public void checkCanDenyTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee) {
        this.delegate().checkCanDenyTablePrivilege(context, privilege, table, grantee);
    }

    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal revokee, boolean grantOption) {
        this.delegate().checkCanRevokeTablePrivilege(context, privilege, table, revokee, grantOption);
    }

    public void checkCanShowRoles(SystemSecurityContext context) {
        this.delegate().checkCanShowRoles(context);
    }

    public void checkCanCreateRole(SystemSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
        this.delegate().checkCanCreateRole(context, role, grantor);
    }

    public void checkCanDropRole(SystemSecurityContext context, String role) {
        this.delegate().checkCanDropRole(context, role);
    }

    public void checkCanGrantRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.delegate().checkCanGrantRoles(context, roles, grantees, adminOption, grantor);
    }

    public void checkCanRevokeRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.delegate().checkCanRevokeRoles(context, roles, grantees, adminOption, grantor);
    }

    public void checkCanShowRoleAuthorizationDescriptors(SystemSecurityContext context) {
        this.delegate().checkCanShowRoleAuthorizationDescriptors(context);
    }

    public void checkCanShowCurrentRoles(SystemSecurityContext context) {
        this.delegate().checkCanShowCurrentRoles(context);
    }

    public void checkCanShowRoleGrants(SystemSecurityContext context) {
        this.delegate().checkCanShowRoleGrants(context);
    }

    public void checkCanExecuteProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName procedure) {
        this.delegate().checkCanExecuteProcedure(systemSecurityContext, procedure);
    }

    public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, String functionName) {
        this.delegate().checkCanExecuteFunction(systemSecurityContext, functionName);
    }

    public void checkCanExecuteTableProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaTableName table, String procedure) {
        this.delegate().checkCanExecuteTableProcedure(systemSecurityContext, table, procedure);
    }

    public Iterable<EventListener> getEventListeners() {
        return this.delegate().getEventListeners();
    }

    public Optional<ViewExpression> getRowFilter(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        return this.delegate().getRowFilter(context, tableName);
    }

    public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        return this.delegate().getColumnMask(context, tableName, columnName, type);
    }
}

