/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.cache;

import com.google.common.cache.AbstractCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.CheckForNull;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public class EvictableCache<K, V>
extends AbstractCache<K, V>
implements Cache<K, V> {
    private final Cache<K, Future<V>> delegate;
    private final AbstractCache.StatsCounter statsCounter = new AbstractCache.SimpleStatsCounter();

    public static <K, V> EvictableCache<K, V> buildWith(CacheBuilder<? super K, Object> cacheBuilder) {
        return new EvictableCache<K, V>(cacheBuilder);
    }

    private EvictableCache(CacheBuilder<? super K, Object> cacheBuilder) {
        Objects.requireNonNull(cacheBuilder, "cacheBuilder is null");
        this.delegate = EvictableCache.buildUnsafeCache(cacheBuilder);
    }

    @SuppressModernizer
    private static <K, V> Cache<K, V> buildUnsafeCache(CacheBuilder<? super K, ? super V> cacheBuilder) {
        return cacheBuilder.build();
    }

    @CheckForNull
    public V getIfPresent(Object key) {
        Future future = (Future)this.delegate.getIfPresent(key);
        if (future != null && future.isDone()) {
            this.statsCounter.recordHits(1);
            return (V)MoreFutures.getDone((Future)future);
        }
        this.statsCounter.recordMisses(1);
        return null;
    }

    public V get(K key, Callable<? extends V> loader) throws ExecutionException {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(loader, "loader is null");
        while (true) {
            SettableFuture newFuture = SettableFuture.create();
            Future future = this.delegate.asMap().computeIfAbsent(key, ignored -> newFuture);
            if (future.isDone() && !future.isCancelled()) {
                this.statsCounter.recordHits(1);
                return (V)MoreFutures.getDone((Future)future);
            }
            this.statsCounter.recordMisses(1);
            if (future == newFuture) {
                V computed;
                long loadStartNanos = System.nanoTime();
                try {
                    computed = loader.call();
                    Objects.requireNonNull(computed, "computed is null");
                }
                catch (Exception e) {
                    this.statsCounter.recordLoadException(System.nanoTime() - loadStartNanos);
                    this.delegate.asMap().remove(key, newFuture);
                    newFuture.cancel(false);
                    throw new ExecutionException(e);
                }
                this.statsCounter.recordLoadSuccess(System.nanoTime() - loadStartNanos);
                newFuture.set(computed);
                return computed;
            }
            try {
                return future.get();
            }
            catch (CancellationException computed) {
                continue;
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Future unexpectedly completed with exception", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted", e);
            }
            break;
        }
    }

    public void put(K key, V value) {
        throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation. Use get(key, callable) instead.");
    }

    public void invalidate(Object key) {
        this.delegate.invalidate(key);
    }

    public void invalidateAll(Iterable<?> keys) {
        this.delegate.invalidateAll(keys);
    }

    public void invalidateAll() {
        this.delegate.invalidateAll();
    }

    public long size() {
        return this.delegate.size();
    }

    public CacheStats stats() {
        return this.statsCounter.snapshot().plus(new CacheStats(0L, 0L, 0L, 0L, 0L, this.delegate.stats().evictionCount()));
    }

    public ConcurrentMap<K, V> asMap() {
        final ConcurrentMap delegate = this.delegate.asMap();
        return new ConcurrentMap<K, V>(){

            @Override
            public V putIfAbsent(K key, V value) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation");
            }

            @Override
            public boolean remove(Object key, Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean replace(K key, V oldValue, V newValue) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation");
            }

            @Override
            public V replace(K key, V value) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation");
            }

            @Override
            public int size() {
                return delegate.size();
            }

            @Override
            public boolean isEmpty() {
                return delegate.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return delegate.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                for (Future future : delegate.values()) {
                    if (!future.isDone() || future.isCancelled() || !Objects.equals(MoreFutures.getDone((Future)future), value)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public V get(Object key) {
                return EvictableCache.this.getIfPresent(key);
            }

            @Override
            public V put(K key, V value) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation. Use get(key, callable) instead.");
            }

            @Override
            public V remove(Object key) {
                Future future = (Future)delegate.remove(key);
                if (future != null && future.isDone() && !future.isCancelled()) {
                    return MoreFutures.getDone((Future)future);
                }
                return null;
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> m) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation. Use get(key, callable) instead.");
            }

            @Override
            public void clear() {
                delegate.clear();
            }

            @Override
            public Set<K> keySet() {
                return delegate.keySet();
            }

            @Override
            public Collection<V> values() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void cleanUp() {
        this.delegate.cleanUp();
    }
}

