/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.cache;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.cache.AbstractLoadingCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.plugin.base.cache.EvictableCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public class EvictableLoadingCache<K, V>
extends AbstractLoadingCache<K, V> {
    private final EvictableCache<K, Token<K>> tokensCache;
    private final LoadingCache<Token<K>, V> dataCache;

    public static <K, V> LoadingCache<K, V> build(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, long maximumSize, boolean recordStats, CacheLoader<K, V> cacheLoader) {
        Objects.requireNonNull(cacheLoader, "cacheLoader is null");
        CacheBuilder tokenCache = CacheBuilder.newBuilder();
        CacheBuilder dataCache = CacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            tokenCache.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
            dataCache.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        if (refreshMillis.isPresent() && (expiresAfterWriteMillis.isEmpty() || expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong())) {
            dataCache.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        tokenCache.maximumSize(maximumSize);
        dataCache.maximumSize(maximumSize);
        if (recordStats) {
            dataCache.recordStats();
        }
        return new EvictableLoadingCache(EvictableCache.buildWith(tokenCache), EvictableLoadingCache.buildUnsafeCache(dataCache, new TokenCacheLoader<K, V>(cacheLoader)));
    }

    @SuppressModernizer
    private static <K, V> LoadingCache<K, V> buildUnsafeCache(CacheBuilder<? super K, ? super V> cacheBuilder, CacheLoader<? super K, V> cacheLoader) {
        return cacheBuilder.build(cacheLoader);
    }

    private EvictableLoadingCache(EvictableCache<K, Token<K>> tokensCache, LoadingCache<Token<K>, V> dataCache) {
        this.tokensCache = Objects.requireNonNull(tokensCache, "tokensCache is null");
        this.dataCache = Objects.requireNonNull(dataCache, "dataCache is null");
    }

    public V get(K key) throws ExecutionException {
        Token token = this.tokensCache.get(key, () -> new Token<Object>(key));
        return (V)this.dataCache.get((Object)token);
    }

    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        HashBiMap keyToToken = HashBiMap.create();
        for (Object key : keys) {
            keyToToken.put(key, (Object)this.tokensCache.get(key, () -> new Token<Object>(key)));
        }
        ImmutableMap values = this.dataCache.getAll((Iterable)keyToToken.values());
        BiMap tokenToKey = keyToToken.inverse();
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry entry : values.entrySet()) {
            Token token = (Token)entry.getKey();
            Object key = tokenToKey.get((Object)token);
            Preconditions.checkState((key != null ? 1 : 0) != 0, (String)"No key found for %s in %s when loading %s", (Object)token, (Object)tokenToKey, keys);
            result.put(key, entry.getValue());
        }
        return result.buildOrThrow();
    }

    public V getIfPresent(Object key) {
        Token<K> token = this.tokensCache.getIfPresent(key);
        if (token == null) {
            return null;
        }
        return (V)this.dataCache.getIfPresent(token);
    }

    public void invalidate(Object key) {
        Token<K> token = this.tokensCache.getIfPresent(key);
        this.tokensCache.invalidate(key);
        if (token != null) {
            this.dataCache.invalidate(token);
        }
    }

    public void invalidateAll(Iterable<?> keys) {
        ImmutableMap tokens = this.tokensCache.getAllPresent(keys);
        this.tokensCache.invalidateAll(keys);
        this.dataCache.invalidateAll((Iterable)tokens.values());
    }

    public void invalidateAll() {
        this.tokensCache.invalidateAll();
        this.dataCache.invalidateAll();
    }

    public long size() {
        return this.dataCache.size();
    }

    public CacheStats stats() {
        return this.dataCache.stats();
    }

    public ConcurrentMap<K, V> asMap() {
        return new ConcurrentMap<K, V>(){
            private final ConcurrentMap<K, Token<K>> tokenCacheMap;
            private final ConcurrentMap<Token<K>, V> dataCacheMap;
            {
                this.tokenCacheMap = EvictableLoadingCache.this.tokensCache.asMap();
                this.dataCacheMap = EvictableLoadingCache.this.dataCache.asMap();
            }

            @Override
            public V putIfAbsent(K key, V value) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation");
            }

            @Override
            public boolean remove(Object key, Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean replace(K key, V oldValue, V newValue) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation");
            }

            @Override
            public V replace(K key, V value) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation");
            }

            @Override
            public int size() {
                return EvictableLoadingCache.this.dataCache.asMap().size();
            }

            @Override
            public boolean isEmpty() {
                return EvictableLoadingCache.this.dataCache.asMap().isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsValue(Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V get(Object key) {
                return EvictableLoadingCache.this.getIfPresent(key);
            }

            @Override
            public V put(K key, V value) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation. Use get(key, callable) instead.");
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> m) {
                throw new UnsupportedOperationException("The operation is not supported, as in inherently races with cache invalidation. Use get(key, callable) instead.");
            }

            @Override
            public void clear() {
                this.dataCacheMap.clear();
                this.tokenCacheMap.clear();
            }

            @Override
            public Set<K> keySet() {
                return this.tokenCacheMap.keySet();
            }

            @Override
            public Collection<V> values() {
                return this.dataCacheMap.values();
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void cleanUp() {
        this.tokensCache.cleanUp();
        this.dataCache.cleanUp();
    }

    private static class TokenCacheLoader<K, V>
    extends CacheLoader<Token<K>, V> {
        private final CacheLoader<K, V> delegate;

        public TokenCacheLoader(CacheLoader<K, V> delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public V load(Token<K> token) throws Exception {
            return (V)this.delegate.load(token.getKey());
        }

        public ListenableFuture<V> reload(Token<K> token, V oldValue) throws Exception {
            return this.delegate.reload(token.getKey(), oldValue);
        }

        public Map<Token<K>, V> loadAll(Iterable<? extends Token<K>> tokens) throws Exception {
            ImmutableList tokenList = ImmutableList.copyOf(tokens);
            ArrayList keys = new ArrayList();
            for (Token token : tokenList) {
                keys.add(token.getKey());
            }
            Map values = this.delegate.loadAll(keys);
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (int i = 0; i < tokenList.size(); ++i) {
                Token token = (Token)tokenList.get(i);
                Object key = keys.get(i);
                Object value = values.get(key);
                if (value == null) continue;
                result.put((Object)token, value);
            }
            return result.buildOrThrow();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).addValue(this.delegate).toString();
        }
    }

    private static class Token<K> {
        private final K key;

        Token(K key) {
            this.key = Objects.requireNonNull(key, "key is null");
        }

        K getKey() {
            return this.key;
        }

        public String toString() {
            return String.format("Cache Token(%s)", this.key);
        }
    }
}

