/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.airlift.slice.Slice;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNewTableLayout;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorResolvedIndex;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableLayoutHandle;
import io.trino.spi.connector.ConnectorTableLayoutResult;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.PointerType;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SampleApplicationResult;
import io.trino.spi.connector.SampleType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.inject.Inject;

public class ClassLoaderSafeConnectorMetadata
implements ConnectorMetadata {
    private final ConnectorMetadata delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorMetadata(@ForClassLoaderSafe ConnectorMetadata delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.getTableLayouts(session, table, constraint, desiredColumns);
            return list;
        }
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableLayout connectorTableLayout = this.delegate.getTableLayout(session, handle);
            return connectorTableLayout;
        }
    }

    public Optional<ConnectorPartitioningHandle> getCommonPartitioningHandle(ConnectorSession session, ConnectorPartitioningHandle left, ConnectorPartitioningHandle right) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getCommonPartitioningHandle(session, left, right);
            return optional;
        }
    }

    public ConnectorTableLayoutHandle makeCompatiblePartitioning(ConnectorSession session, ConnectorTableLayoutHandle tableLayoutHandle, ConnectorPartitioningHandle partitioningHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableLayoutHandle connectorTableLayoutHandle = this.delegate.makeCompatiblePartitioning(session, tableLayoutHandle, partitioningHandle);
            return connectorTableLayoutHandle;
        }
    }

    public ConnectorTableHandle makeCompatiblePartitioning(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorPartitioningHandle partitioningHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.makeCompatiblePartitioning(session, tableHandle, partitioningHandle);
            return connectorTableHandle;
        }
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getNewTableLayout(session, tableMetadata);
            return optional;
        }
    }

    public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getInsertLayout(session, tableHandle);
            return optional;
        }
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableStatisticsMetadata tableStatisticsMetadata = this.delegate.getStatisticsCollectionMetadataForWrite(session, tableMetadata);
            return tableStatisticsMetadata;
        }
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableStatisticsMetadata tableStatisticsMetadata = this.delegate.getStatisticsCollectionMetadata(session, tableMetadata);
            return tableStatisticsMetadata;
        }
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.beginStatisticsCollection(session, tableHandle);
            return connectorTableHandle;
        }
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.finishStatisticsCollection(session, tableHandle, computedStatistics);
        }
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.schemaExists(session, schemaName);
            return bl;
        }
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.listSchemaNames(session);
            return list;
        }
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.getTableHandle(session, tableName);
            return connectorTableHandle;
        }
    }

    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.getTableHandleForStatisticsCollection(session, tableName, analyzeProperties);
            return connectorTableHandle;
        }
    }

    public Optional<ConnectorTableExecuteHandle> getTableHandleForExecute(ConnectorSession session, ConnectorTableHandle tableHandle, String procedureName, Map<String, Object> executeProperties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getTableHandleForExecute(session, tableHandle, procedureName, executeProperties);
            return optional;
        }
    }

    public Optional<ConnectorTableExecuteHandle> getTableHandleForExecute(ConnectorSession session, ConnectorTableHandle tableHandle, String procedureName, Map<String, Object> executeProperties, RetryMode retryMode) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getTableHandleForExecute(session, tableHandle, procedureName, executeProperties, retryMode);
            return optional;
        }
    }

    public Optional<ConnectorNewTableLayout> getLayoutForTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getLayoutForTableExecute(session, tableExecuteHandle);
            return optional;
        }
    }

    public BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorTableHandle updatedSourceTableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            BeginTableExecuteResult beginTableExecuteResult = this.delegate.beginTableExecute(session, tableExecuteHandle, updatedSourceTableHandle);
            return beginTableExecuteResult;
        }
    }

    public void finishTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> tableExecuteState) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.finishTableExecute(session, tableExecuteHandle, fragments, tableExecuteState);
        }
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getSystemTable(session, tableName);
            return optional;
        }
    }

    public ConnectorTableSchema getTableSchema(ConnectorSession session, ConnectorTableHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableSchema connectorTableSchema = this.delegate.getTableSchema(session, table);
            return connectorTableSchema;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableMetadata connectorTableMetadata = this.delegate.getTableMetadata(session, table);
            return connectorTableMetadata;
        }
    }

    public Optional<Object> getInfo(ConnectorTableLayoutHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getInfo(table);
            return optional;
        }
    }

    public Optional<Object> getInfo(ConnectorTableHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getInfo(table);
            return optional;
        }
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.listTables(session, schemaName);
            return list;
        }
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map map = this.delegate.getColumnHandles(session, tableHandle);
            return map;
        }
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ColumnMetadata columnMetadata = this.delegate.getColumnMetadata(session, tableHandle, columnHandle);
            return columnMetadata;
        }
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map map = this.delegate.listTableColumns(session, prefix);
            return map;
        }
    }

    public Stream<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Stream stream = this.delegate.streamTableColumns(session, prefix);
            return stream;
        }
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableStatistics tableStatistics = this.delegate.getTableStatistics(session, tableHandle, constraint);
            return tableStatistics;
        }
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.addColumn(session, tableHandle, column);
        }
    }

    public void setTableAuthorization(ConnectorSession session, SchemaTableName table, TrinoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.setTableAuthorization(session, table, principal);
        }
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createSchema(session, schemaName, properties, owner);
        }
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropSchema(session, schemaName);
        }
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameSchema(session, source, target);
        }
    }

    public void setSchemaAuthorization(ConnectorSession session, String source, TrinoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.setSchemaAuthorization(session, source, principal);
        }
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createTable(session, tableMetadata, ignoreExisting);
        }
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropTable(session, tableHandle);
        }
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.truncateTable(session, tableHandle);
        }
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameColumn(session, tableHandle, source, target);
        }
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropColumn(session, tableHandle, column);
        }
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameTable(session, tableHandle, newTableName);
        }
    }

    public void setTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Object> properties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.setTableProperties(session, tableHandle, properties);
        }
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.setTableComment(session, tableHandle, comment);
        }
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.setColumnComment(session, tableHandle, column, comment);
        }
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorOutputTableHandle connectorOutputTableHandle = this.delegate.beginCreateTable(session, tableMetadata, layout);
            return connectorOutputTableHandle;
        }
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout, RetryMode retryMode) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorOutputTableHandle connectorOutputTableHandle = this.delegate.beginCreateTable(session, tableMetadata, layout, retryMode);
            return connectorOutputTableHandle;
        }
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.finishCreateTable(session, tableHandle, fragments, computedStatistics);
            return optional;
        }
    }

    public void beginQuery(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.beginQuery(session);
        }
    }

    public void cleanupQuery(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.cleanupQuery(session);
        }
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorInsertTableHandle connectorInsertTableHandle = this.delegate.beginInsert(session, tableHandle);
            return connectorInsertTableHandle;
        }
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorInsertTableHandle connectorInsertTableHandle = this.delegate.beginInsert(session, tableHandle, columns);
            return connectorInsertTableHandle;
        }
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorInsertTableHandle connectorInsertTableHandle = this.delegate.beginInsert(session, tableHandle, columns, retryMode);
            return connectorInsertTableHandle;
        }
    }

    public boolean supportsMissingColumnsOnInsert() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.supportsMissingColumnsOnInsert();
            return bl;
        }
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.finishInsert(session, insertHandle, fragments, computedStatistics);
            return optional;
        }
    }

    public boolean delegateMaterializedViewRefreshToConnector(ConnectorSession session, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.delegateMaterializedViewRefreshToConnector(session, viewName);
            return bl;
        }
    }

    public CompletableFuture<?> refreshMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture completableFuture = this.delegate.refreshMaterializedView(session, viewName);
            return completableFuture;
        }
    }

    public ConnectorInsertTableHandle beginRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorTableHandle> sourceTableHandles) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorInsertTableHandle connectorInsertTableHandle = this.delegate.beginRefreshMaterializedView(session, tableHandle, sourceTableHandles);
            return connectorInsertTableHandle;
        }
    }

    public ConnectorInsertTableHandle beginRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorTableHandle> sourceTableHandles, RetryMode retryMode) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorInsertTableHandle connectorInsertTableHandle = this.delegate.beginRefreshMaterializedView(session, tableHandle, sourceTableHandles, retryMode);
            return connectorInsertTableHandle;
        }
    }

    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<ConnectorTableHandle> sourceTableHandles) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.finishRefreshMaterializedView(session, tableHandle, insertHandle, fragments, computedStatistics, sourceTableHandles);
            return optional;
        }
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ColumnHandle columnHandle = this.delegate.getDeleteRowIdColumnHandle(session, tableHandle);
            return columnHandle;
        }
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createView(session, viewName, definition, replace);
        }
    }

    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameView(session, source, target);
        }
    }

    public void setViewAuthorization(ConnectorSession session, SchemaTableName viewName, TrinoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.setViewAuthorization(session, viewName, principal);
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropView(session, viewName);
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.listViews(session, schemaName);
            return list;
        }
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map map = this.delegate.getViews(session, schemaName);
            return map;
        }
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getView(session, viewName);
            return optional;
        }
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, CatalogSchemaName schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map map = this.delegate.getSchemaProperties(session, schemaName);
            return map;
        }
    }

    public Optional<TrinoPrincipal> getSchemaOwner(ConnectorSession session, CatalogSchemaName schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getSchemaOwner(session, schemaName);
            return optional;
        }
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ColumnHandle columnHandle = this.delegate.getUpdateRowIdColumnHandle(session, tableHandle, updatedColumns);
            return columnHandle;
        }
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.beginDelete(session, tableHandle);
            return connectorTableHandle;
        }
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.beginDelete(session, tableHandle, retryMode);
            return connectorTableHandle;
        }
    }

    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.finishDelete(session, tableHandle, fragments);
        }
    }

    public boolean supportsMetadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.supportsMetadataDelete(session, tableHandle, tableLayoutHandle);
            return bl;
        }
    }

    public OptionalLong metadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            OptionalLong optionalLong = this.delegate.metadataDelete(session, tableHandle, tableLayoutHandle);
            return optionalLong;
        }
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyDelete(session, handle);
            return optional;
        }
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle handle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            OptionalLong optionalLong = this.delegate.executeDelete(session, handle);
            return optionalLong;
        }
    }

    public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.resolveIndex(session, tableHandle, indexableColumns, outputColumns, tupleDomain);
            return optional;
        }
    }

    public boolean roleExists(ConnectorSession session, String role) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.roleExists(session, role);
            return bl;
        }
    }

    public void createRole(ConnectorSession session, String role, Optional<TrinoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createRole(session, role, grantor);
        }
    }

    public void dropRole(ConnectorSession session, String role) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropRole(session, role);
        }
    }

    public Set<String> listRoles(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.listRoles(session);
            return set;
        }
    }

    public Set<RoleGrant> listAllRoleGrants(ConnectorSession session, Optional<Set<String>> roles, Optional<Set<String>> grantees, OptionalLong limit) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.listAllRoleGrants(session, roles, grantees, limit);
            return set;
        }
    }

    public Set<RoleGrant> listRoleGrants(ConnectorSession session, TrinoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.listRoleGrants(session, principal);
            return set;
        }
    }

    public void grantRoles(ConnectorSession connectorSession, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.grantRoles(connectorSession, roles, grantees, adminOption, grantor);
        }
    }

    public void revokeRoles(ConnectorSession connectorSession, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.revokeRoles(connectorSession, roles, grantees, adminOption, grantor);
        }
    }

    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, TrinoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.listApplicableRoles(session, principal);
            return set;
        }
    }

    public Set<String> listEnabledRoles(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.listEnabledRoles(session);
            return set;
        }
    }

    public void grantSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.grantSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
        }
    }

    public void denySchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.denySchemaPrivileges(session, schemaName, privileges, grantee);
        }
    }

    public void revokeSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.revokeSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
        }
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.grantTablePrivileges(session, tableName, privileges, grantee, grantOption);
        }
    }

    public void denyTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.denyTablePrivileges(session, tableName, privileges, grantee);
        }
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.revokeTablePrivileges(session, tableName, privileges, grantee, grantOption);
        }
    }

    public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix prefix) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.listTablePrivileges(session, prefix);
            return list;
        }
    }

    public boolean usesLegacyTableLayouts() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.usesLegacyTableLayouts();
            return bl;
        }
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableProperties connectorTableProperties = this.delegate.getTableProperties(session, table);
            return connectorTableProperties;
        }
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyLimit(session, table, limit);
            return optional;
        }
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyFilter(session, table, constraint);
            return optional;
        }
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyProjection(session, table, projections, assignments);
            return optional;
        }
    }

    public Optional<SampleApplicationResult<ConnectorTableHandle>> applySample(ConnectorSession session, ConnectorTableHandle table, SampleType sampleType, double sampleRatio) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applySample(session, table, sampleType, sampleRatio);
            return optional;
        }
    }

    public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyAggregation(session, table, aggregates, assignments, groupingSets);
            return optional;
        }
    }

    public Optional<JoinApplicationResult<ConnectorTableHandle>> applyJoin(ConnectorSession session, JoinType joinType, ConnectorTableHandle left, ConnectorTableHandle right, List<JoinCondition> joinConditions, Map<String, ColumnHandle> leftAssignments, Map<String, ColumnHandle> rightAssignments, JoinStatistics statistics) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyJoin(session, joinType, left, right, joinConditions, leftAssignments, rightAssignments, statistics);
            return optional;
        }
    }

    public Optional<TopNApplicationResult<ConnectorTableHandle>> applyTopN(ConnectorSession session, ConnectorTableHandle table, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyTopN(session, table, topNCount, sortItems, assignments);
            return optional;
        }
    }

    public void validateScan(ConnectorSession session, ConnectorTableHandle handle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.validateScan(session, handle);
        }
    }

    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createMaterializedView(session, viewName, definition, replace, ignoreExisting);
        }
    }

    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropMaterializedView(session, viewName);
        }
    }

    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.listMaterializedViews(session, schemaName);
            return list;
        }
    }

    public Map<SchemaTableName, ConnectorMaterializedViewDefinition> getMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map map = this.delegate.getMaterializedViews(session, schemaName);
            return map;
        }
    }

    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getMaterializedView(session, viewName);
            return optional;
        }
    }

    public MaterializedViewFreshness getMaterializedViewFreshness(ConnectorSession session, SchemaTableName name) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            MaterializedViewFreshness materializedViewFreshness = this.delegate.getMaterializedViewFreshness(session, name);
            return materializedViewFreshness;
        }
    }

    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameMaterializedView(session, source, target);
        }
    }

    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.applyTableScanRedirect(session, tableHandle);
            return optional;
        }
    }

    public ConnectorTableHandle beginUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.beginUpdate(session, tableHandle, updatedColumns);
            return connectorTableHandle;
        }
    }

    public ConnectorTableHandle beginUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns, RetryMode retryMode) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.beginUpdate(session, tableHandle, updatedColumns, retryMode);
            return connectorTableHandle;
        }
    }

    public void finishUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.finishUpdate(session, tableHandle, fragments);
        }
    }

    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.redirectTable(session, tableName);
            return optional;
        }
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.getTableHandle(session, tableName, startVersion, endVersion);
            return connectorTableHandle;
        }
    }

    public boolean isSupportedVersionType(ConnectorSession session, SchemaTableName tableName, PointerType pointerType, Type versioning) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.isSupportedVersionType(session, tableName, pointerType, versioning);
            return bl;
        }
    }
}

