/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.base.security.AnyCatalogPermissionsRule;
import io.trino.plugin.base.security.SessionPropertyAccessControlRule;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class CatalogSessionPropertyAccessControlRule {
    public static final CatalogSessionPropertyAccessControlRule ALLOW_ALL = new CatalogSessionPropertyAccessControlRule(true, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private final Optional<Pattern> catalogRegex;
    private final SessionPropertyAccessControlRule sessionPropertyAccessControlRule;

    @JsonCreator
    public CatalogSessionPropertyAccessControlRule(@JsonProperty(value="allow") boolean allow, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="role") Optional<Pattern> roleRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="property") Optional<Pattern> propertyRegex, @JsonProperty(value="catalog") Optional<Pattern> catalogRegex) {
        this.sessionPropertyAccessControlRule = new SessionPropertyAccessControlRule(allow, userRegex, roleRegex, groupRegex, propertyRegex);
        this.catalogRegex = Objects.requireNonNull(catalogRegex, "catalogRegex is null");
    }

    public Optional<Boolean> match(String user, Set<String> roles, Set<String> groups, String catalog, String property) {
        if (!this.catalogRegex.map(regex -> regex.matcher(catalog).matches()).orElse(true).booleanValue()) {
            return Optional.empty();
        }
        return this.sessionPropertyAccessControlRule.match(user, roles, groups, property);
    }

    Optional<AnyCatalogPermissionsRule> toAnyCatalogPermissionsRule() {
        if (!this.sessionPropertyAccessControlRule.isAllow()) {
            return Optional.empty();
        }
        return Optional.of(new AnyCatalogPermissionsRule(this.sessionPropertyAccessControlRule.getUserRegex(), this.sessionPropertyAccessControlRule.getRoleRegex(), this.sessionPropertyAccessControlRule.getGroupRegex(), this.catalogRegex));
    }
}

