/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class SessionPropertyAccessControlRule {
    public static final SessionPropertyAccessControlRule ALLOW_ALL = new SessionPropertyAccessControlRule(true, Optional.empty(), Optional.empty(), Optional.empty());
    private final boolean allow;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> groupRegex;
    private final Optional<Pattern> propertyRegex;

    @JsonCreator
    public SessionPropertyAccessControlRule(@JsonProperty(value="allow") boolean allow, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="property") Optional<Pattern> propertyRegex) {
        this.allow = allow;
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.groupRegex = Objects.requireNonNull(groupRegex, "groupRegex is null");
        this.propertyRegex = Objects.requireNonNull(propertyRegex, "propertyRegex is null");
    }

    boolean isAllow() {
        return this.allow;
    }

    Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }

    Optional<Pattern> getGroupRegex() {
        return this.groupRegex;
    }

    public Optional<Boolean> match(String user, Set<String> groups, String property) {
        if (this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true).booleanValue() && this.groupRegex.map(regex -> groups.stream().anyMatch(group -> regex.matcher((CharSequence)group).matches())).orElse(true).booleanValue() && this.propertyRegex.map(regex -> regex.matcher(property).matches()).orElse(true).booleanValue()) {
            return Optional.of(this.allow);
        }
        return Optional.empty();
    }
}

