/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;

public class SystemInformationRule {
    private final Set<AccessMode> allow;
    private final Optional<Pattern> userRegex;

    @JsonCreator
    public SystemInformationRule(@JsonProperty(value="allow") Set<AccessMode> allow, @JsonProperty(value="user") Optional<Pattern> userRegex) {
        this.allow = ImmutableSet.copyOf((Collection)Objects.requireNonNull(allow, "allow is null"));
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
    }

    public Optional<Set<AccessMode>> match(String user) {
        if (this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true).booleanValue()) {
            return Optional.of(this.allow);
        }
        return Optional.empty();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("allow", this.allow).add("userRegex", this.userRegex.orElse(null)).toString();
    }

    public static enum AccessMode {
        READ("read"),
        WRITE("write");

        private static final Map<String, AccessMode> modeByName;
        private final String stringValue;

        private AccessMode(String stringValue) {
            this.stringValue = Objects.requireNonNull(stringValue, "stringValue is null");
        }

        @JsonValue
        public String toString() {
            return this.stringValue;
        }

        @JsonCreator
        public static AccessMode fromJson(Object value) {
            AccessMode accessMode;
            if (value instanceof String && (accessMode = modeByName.get(((String)value).toLowerCase(Locale.US))) != null) {
                return accessMode;
            }
            throw new IllegalArgumentException("Unknown " + AccessMode.class.getSimpleName() + ": " + value);
        }

        static {
            modeByName = (Map)Arrays.stream(AccessMode.values()).collect(ImmutableMap.toImmutableMap(AccessMode::toString, Function.identity()));
        }
    }
}

