/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ModuleReader {
    private ModuleReader() {
    }

    public static Map<String, String> mapModulesToPlugins(File rootPom) {
        List<String> modules = ModuleReader.readTrinoPlugins(rootPom);
        return modules.stream().collect(Collectors.toMap(Function.identity(), module -> ModuleReader.readPluginClassName(rootPom, module)));
    }

    private static List<String> readTrinoPlugins(File rootPom) {
        List list;
        FileReader fileReader = new FileReader(rootPom, StandardCharsets.UTF_8);
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)fileReader);
            list = (List)model.getModules().stream().filter(module -> ModuleReader.isTrinoPlugin(Objects.requireNonNullElse(rootPom.getParent(), ".") + "/" + module)).collect(ImmutableList.toImmutableList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Couldn't read file %s", rootPom), e);
            }
            catch (XmlPullParserException e) {
                throw new RuntimeException(String.format("Couldn't parse file %s", rootPom), e);
            }
        }
        fileReader.close();
        return list;
    }

    private static boolean isTrinoPlugin(String module) {
        boolean bl;
        String modulePom = module + "/pom.xml";
        FileReader fileReader = new FileReader(modulePom, StandardCharsets.UTF_8);
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)fileReader);
            bl = model.getPackaging().equals("trino-plugin");
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Couldn't read file %s", modulePom), e);
            }
            catch (XmlPullParserException e) {
                throw new RuntimeException(String.format("Couldn't parse file %s", modulePom), e);
            }
        }
        fileReader.close();
        return bl;
    }

    private static String readPluginClassName(File rootPom, String module) {
        String string;
        block8: {
            Path target = Path.of(Objects.requireNonNullElse(rootPom.getParent(), "."), module, "target");
            BiPredicate<Path, BasicFileAttributes> matcher = (path, attributes) -> path.toFile().getName().matches(".*-services\\.jar");
            Stream<Path> files = Files.find(target, 1, matcher, new FileVisitOption[0]);
            try {
                string = files.findFirst().map(jarFile -> ModuleReader.readPluginClassName(jarFile.toFile())).orElseThrow(() -> new MissingResourceException(String.format("Couldn't find plugin name in services jar for module %s", module), Plugin.class.getName(), module));
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(String.format("Couldn't read services jar for module %s", module), e);
                }
            }
            files.close();
        }
        return string;
    }

    private static String readPluginClassName(File serviceJar) {
        try {
            ZipFile zipFile = new ZipFile(serviceJar);
            return zipFile.stream().filter(entry -> !entry.isDirectory() && entry.getName().equals("META-INF/services/io.trino.spi.Plugin")).findFirst().map(entry -> {
                String string;
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream((ZipEntry)entry));
                try {
                    string = new String(bis.readAllBytes(), StandardCharsets.UTF_8).trim();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            bis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(String.format("Couldn't read plugin's service descriptor in %s", serviceJar), e);
                    }
                }
                bis.close();
                return string;
            }).orElseThrow(() -> new MissingResourceException(String.format("Couldn't find 'META-INF/services/io.trino.spi.Plugin' file in the service JAR %s", serviceJar.getPath()), Plugin.class.getName(), serviceJar.getPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Couldn't process service JAR %s", serviceJar), e);
        }
    }
}

