/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.TableFunctionDescriptorArgument;
import io.trino.sql.tree.TableFunctionTableArgument;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableFunctionArgument
extends Node {
    private final Optional<Identifier> name;
    private final Node value;

    public TableFunctionArgument(NodeLocation location, Optional<Identifier> name, Node value) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(value, "value is null");
        Preconditions.checkArgument((value instanceof TableFunctionTableArgument || value instanceof TableFunctionDescriptorArgument || value instanceof Expression ? 1 : 0) != 0);
        this.value = value;
    }

    public Optional<Identifier> getName() {
        return this.name;
    }

    public Node getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTableFunctionArgument(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableFunctionArgument other = (TableFunctionArgument)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public String toString() {
        return this.name.map(identifier -> String.valueOf(identifier) + " => ").orElse("") + String.valueOf(this.value);
    }

    @Override
    public boolean shallowEquals(Node o) {
        if (!TableFunctionArgument.sameClass(this, o)) {
            return false;
        }
        return Objects.equals(this.name, ((TableFunctionArgument)o).name);
    }
}

