/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;

public class SetDefaultValue
extends Statement {
    private final QualifiedName tableName;
    private final QualifiedName columnName;
    private final Expression defaultValue;
    private final boolean tableExists;

    public SetDefaultValue(NodeLocation location, QualifiedName tableName, QualifiedName columnName, Expression defaultValue, boolean tableExists) {
        super(location);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is null");
        this.tableExists = tableExists;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public QualifiedName getColumnName() {
        return this.columnName;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetDefaultValue(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.defaultValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.columnName, this.defaultValue, this.tableExists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetDefaultValue o = (SetDefaultValue)obj;
        return Objects.equals(this.tableName, o.tableName) && Objects.equals(this.columnName, o.columnName) && Objects.equals(this.defaultValue, o.defaultValue) && this.tableExists == o.tableExists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.tableName).add("column", (Object)this.columnName).add("defaultValue", (Object)this.defaultValue).add("tableExists", this.tableExists).toString();
    }
}

