/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import io.trino.sql.parser.ParsingException;
import io.trino.sql.tree.NodeLocation;
import java.util.Objects;

public class NumericParser {
    private NumericParser() {
    }

    public static long parseNumeric(String value, NodeLocation location) {
        Objects.requireNonNull(value, "value is null");
        try {
            return NumericParser.parseNumeric(value);
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Invalid numeric literal: " + value, location);
        }
    }

    private static long parseNumeric(String value) {
        if ((value = value.replace("_", "")).startsWith("0x") || value.startsWith("0X")) {
            return Long.parseLong(value.substring(2), 16);
        }
        if (value.startsWith("-0x") || value.startsWith("-0X")) {
            return Long.parseLong("-" + value.substring(3), 16);
        }
        if (value.startsWith("0b") || value.startsWith("0B")) {
            return Long.parseLong(value.substring(2), 2);
        }
        if (value.startsWith("-0b") || value.startsWith("-0B")) {
            return Long.parseLong("-" + value.substring(3), 2);
        }
        if (value.startsWith("0o") || value.startsWith("0O")) {
            return Long.parseLong(value.substring(2), 8);
        }
        if (value.startsWith("-0o") || value.startsWith("-0O")) {
            return Long.parseLong("-" + value.substring(3), 8);
        }
        return Long.parseLong(value);
    }
}

