/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SaveMode;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CreateBranch
extends Statement {
    private final QualifiedName tableName;
    private final SaveMode saveMode;
    private final Identifier branchName;
    private final Optional<Identifier> fromBranch;
    private final List<Property> properties;

    public CreateBranch(NodeLocation location, QualifiedName tableName, Identifier branchName, Optional<Identifier> fromBranch, SaveMode saveMode, List<Property> properties) {
        super(location);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.saveMode = Objects.requireNonNull(saveMode, "saveMode is null");
        this.branchName = Objects.requireNonNull(branchName, "branchName is null");
        this.fromBranch = Objects.requireNonNull(fromBranch, "fromBranch is null");
        this.properties = ImmutableList.copyOf(properties);
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public Identifier getBranchName() {
        return this.branchName;
    }

    public Optional<Identifier> getFromBranch() {
        return this.fromBranch;
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateBranch(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().addAll(this.properties).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateBranch o = (CreateBranch)obj;
        return Objects.equals(this.tableName, o.tableName) && Objects.equals(this.branchName, o.branchName) && Objects.equals(this.fromBranch, o.fromBranch) && this.saveMode == o.saveMode && Objects.equals(this.properties, o.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.tableName, this.branchName, this.fromBranch, this.saveMode, this.properties});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("branchName", (Object)this.branchName).add("fromBranch", this.fromBranch).add("saveMode", (Object)this.saveMode).add("properties", this.properties).toString();
    }
}

