/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataTypeParameter;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.NumericParser;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NumericParameter
extends DataTypeParameter {
    private final String value;
    private final long parsedValue;

    public NumericParameter(NodeLocation location, String value) {
        this(Optional.of(location), value);
    }

    public NumericParameter(Optional<NodeLocation> location, String value) {
        super(location);
        this.value = Objects.requireNonNull(value, "value is null");
        this.parsedValue = NumericParser.parseNumeric(value, location.orElse(new NodeLocation(1, 1)));
    }

    public String getValue() {
        return this.value;
    }

    public long getParsedValue() {
        return this.parsedValue;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNumericTypeParameter(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericParameter that = (NumericParameter)o;
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!NumericParameter.sameClass(this, other)) {
            return false;
        }
        return Objects.equals(this.value, ((NumericParameter)other).value);
    }
}

