/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;

public final class FastForwardBranch
extends Statement {
    private final QualifiedName tableName;
    private final Identifier sourceBranchName;
    private final Identifier targetBranchName;

    public FastForwardBranch(NodeLocation location, QualifiedName tableName, Identifier sourceBranchName, Identifier targetBranchName) {
        super(location);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.sourceBranchName = Objects.requireNonNull(sourceBranchName, "sourceBranchName is null");
        this.targetBranchName = Objects.requireNonNull(targetBranchName, "targetBranchName is null");
    }

    public QualifiedName geTableName() {
        return this.tableName;
    }

    public Identifier getSourceBranchName() {
        return this.sourceBranchName;
    }

    public Identifier getTargetBranchName() {
        return this.targetBranchName;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFastForwardBranch(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FastForwardBranch o = (FastForwardBranch)obj;
        return Objects.equals(this.tableName, o.tableName) && Objects.equals(this.sourceBranchName, o.sourceBranchName) && Objects.equals(this.targetBranchName, o.targetBranchName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.sourceBranchName, this.targetBranchName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("sourceBranchName", (Object)this.sourceBranchName).add("targetBranchName", (Object)this.targetBranchName).toString();
    }
}

