/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;

public class DropBranch
extends Statement {
    private final QualifiedName tableName;
    private final boolean exists;
    private final Identifier branchName;

    public DropBranch(NodeLocation location, QualifiedName tableName, boolean exists, Identifier branchName) {
        super(location);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.exists = exists;
        this.branchName = Objects.requireNonNull(branchName, "branchName is null");
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public boolean isExists() {
        return this.exists;
    }

    public Identifier getBranchName() {
        return this.branchName;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropBranch(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.exists, this.branchName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropBranch o = (DropBranch)obj;
        return Objects.equals(this.tableName, o.tableName) && this.exists == o.exists && Objects.equals(this.branchName, o.branchName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("exists", this.exists).add("branchName", (Object)this.branchName).toString();
    }
}

