/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LambdaArgumentDeclaration
extends Expression {
    private final Identifier name;

    public LambdaArgumentDeclaration(NodeLocation location, Identifier name) {
        super(location);
        this.name = name;
    }

    @Deprecated
    public LambdaArgumentDeclaration(Identifier name) {
        super(Optional.empty());
        this.name = name;
    }

    public Identifier getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLambdaArgumentDeclaration(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaArgumentDeclaration that = (LambdaArgumentDeclaration)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!LambdaArgumentDeclaration.sameClass(this, other)) {
            return false;
        }
        return this.name.equals(((LambdaArgumentDeclaration)other).getName());
    }
}

