/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.RoutineCharacteristic;
import java.util.List;
import java.util.Objects;

public final class DeterministicCharacteristic
extends RoutineCharacteristic {
    private final boolean deterministic;

    public DeterministicCharacteristic(NodeLocation location, boolean deterministic) {
        super(location);
        this.deterministic = deterministic;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDeterministicCharacteristic(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DeterministicCharacteristic)) return false;
        DeterministicCharacteristic other = (DeterministicCharacteristic)obj;
        if (this.deterministic != other.deterministic) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.deterministic);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deterministic", this.deterministic).toString();
    }
}

