/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SkipTo
extends Node {
    private final Position position;
    private final Optional<Identifier> identifier;

    public static SkipTo skipPastLastRow(NodeLocation location) {
        return new SkipTo(location, Position.PAST_LAST, Optional.empty());
    }

    public static SkipTo skipToNextRow(NodeLocation location) {
        return new SkipTo(location, Position.NEXT, Optional.empty());
    }

    public static SkipTo skipToFirst(NodeLocation location, Identifier identifier) {
        return new SkipTo(location, Position.FIRST, Optional.of(identifier));
    }

    public static SkipTo skipToLast(NodeLocation location, Identifier identifier) {
        return new SkipTo(location, Position.LAST, Optional.of(identifier));
    }

    private SkipTo(NodeLocation location, Position position, Optional<Identifier> identifier) {
        super(location);
        Objects.requireNonNull(position, "position is null");
        Objects.requireNonNull(identifier, "identifier is null");
        Preconditions.checkArgument((identifier.isPresent() || position == Position.PAST_LAST || position == Position.NEXT ? 1 : 0) != 0, (String)"missing identifier in SKIP TO %s", (Object)position.name());
        Preconditions.checkArgument((!identifier.isPresent() || position == Position.FIRST || position == Position.LAST ? 1 : 0) != 0, (String)"unexpected identifier in SKIP TO %s", (Object)position.name());
        this.position = position;
        this.identifier = identifier;
    }

    public Position getPosition() {
        return this.position;
    }

    public Optional<Identifier> getIdentifier() {
        return this.identifier;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSkipTo(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return (List)this.identifier.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("position", (Object)this.position).add("identifier", this.identifier.orElse(null)).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkipTo that = (SkipTo)o;
        return Objects.equals((Object)this.position, (Object)that.position) && Objects.equals(this.identifier, that.identifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.position, this.identifier});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!SkipTo.sameClass(this, other)) {
            return false;
        }
        return this.position == ((SkipTo)other).position;
    }

    public static enum Position {
        PAST_LAST,
        NEXT,
        FIRST,
        LAST;

    }
}

