/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;

public final class DropCatalog
extends Statement {
    private final Identifier catalogName;
    private final boolean exists;
    private final boolean cascade;

    public DropCatalog(NodeLocation location, Identifier catalogName, boolean exists, boolean cascade) {
        super(location);
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.exists = exists;
        this.cascade = cascade;
    }

    public Identifier getCatalogName() {
        return this.catalogName;
    }

    public boolean isExists() {
        return this.exists;
    }

    public boolean isCascade() {
        return this.cascade;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropCatalog(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropCatalog o = (DropCatalog)obj;
        return Objects.equals(this.catalogName, o.catalogName) && this.exists == o.exists && this.cascade == o.cascade;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalogName, this.exists);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("exists", this.exists).add("cascade", this.cascade).toString();
    }
}

