/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CurrentTime
extends Expression {
    private final Optional<Integer> precision;

    public CurrentTime(NodeLocation location, Optional<Integer> precision) {
        super(location);
        Objects.requireNonNull(precision, "precision is null");
        this.precision = precision;
    }

    public Optional<Integer> getPrecision() {
        return this.precision;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCurrentTime(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentTime that = (CurrentTime)o;
        return Objects.equals(this.precision, that.precision);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.precision);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!CurrentTime.sameClass(this, other)) {
            return false;
        }
        CurrentTime otherNode = (CurrentTime)other;
        return Objects.equals(this.precision, otherNode.precision);
    }
}

