/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateCatalog
extends Statement {
    private final Identifier catalogName;
    private final boolean notExists;
    private final Identifier connectorName;
    private final List<Property> properties;
    private final Optional<PrincipalSpecification> principal;
    private final Optional<String> comment;

    public CreateCatalog(NodeLocation location, Identifier catalogName, boolean notExists, Identifier connectorName, List<Property> properties, Optional<PrincipalSpecification> principal, Optional<String> comment) {
        super(location);
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.notExists = notExists;
        this.connectorName = Objects.requireNonNull(connectorName, "connectorName is null");
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public Identifier getCatalogName() {
        return this.catalogName;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public Identifier getConnectorName() {
        return this.connectorName;
    }

    public Optional<PrincipalSpecification> getPrincipal() {
        return this.principal;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateCatalog(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.copyOf(this.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalogName, this.notExists, this.properties, this.comment);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateCatalog o = (CreateCatalog)obj;
        return Objects.equals(this.catalogName, o.catalogName) && this.notExists == o.notExists && Objects.equals(this.properties, o.properties) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("notExists", this.notExists).add("properties", this.properties).add("comment", this.comment).toString();
    }
}

