/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SubscriptExpression
extends Expression {
    private final Expression base;
    private final Expression index;

    @Deprecated
    public SubscriptExpression(Expression base, Expression index) {
        super(Optional.empty());
        this.base = Objects.requireNonNull(base, "base is null");
        this.index = Objects.requireNonNull(index, "index is null");
    }

    public SubscriptExpression(NodeLocation location, Expression base, Expression index) {
        super(location);
        this.base = Objects.requireNonNull(base, "base is null");
        this.index = Objects.requireNonNull(index, "index is null");
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSubscriptExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.base, (Object)this.index);
    }

    public Expression getBase() {
        return this.base;
    }

    public Expression getIndex() {
        return this.index;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptExpression that = (SubscriptExpression)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.index, that.index);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.index);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return SubscriptExpression.sameClass(this, other);
    }
}

