/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.MergeCase;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MergeUpdate
extends MergeCase {
    private final List<Assignment> assignments;

    @Deprecated
    public MergeUpdate(Optional<Expression> expression, List<Assignment> assignments) {
        super(Optional.empty(), expression);
        this.assignments = ImmutableList.copyOf((Collection)Objects.requireNonNull(assignments, "assignments is null"));
    }

    public MergeUpdate(NodeLocation location, Optional<Expression> expression, List<Assignment> assignments) {
        super(location, expression);
        this.assignments = ImmutableList.copyOf((Collection)Objects.requireNonNull(assignments, "assignments is null"));
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitMergeUpdate(this, context);
    }

    @Override
    public List<Identifier> getSetColumns() {
        return (List)this.assignments.stream().map(Assignment::getTarget).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<Expression> getSetExpressions() {
        return (List)this.assignments.stream().map(Assignment::getValue).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.expression.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        this.assignments.forEach(assignment -> {
            builder.add((Object)assignment.getTarget());
            builder.add((Object)assignment.getValue());
        });
        return builder.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.assignments);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MergeUpdate o = (MergeUpdate)obj;
        return Objects.equals(this.expression, o.expression) && Objects.equals(this.assignments, o.assignments);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expression", this.expression.orElse(null)).add("assignments", this.assignments).omitNullValues().toString();
    }

    public static class Assignment {
        private final Identifier target;
        private final Expression value;

        public Assignment(Identifier target, Expression value) {
            this.target = Objects.requireNonNull(target, "target is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public Identifier getTarget() {
            return this.target;
        }

        public Expression getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.target, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Assignment o = (Assignment)obj;
            return Objects.equals(this.target, o.target) && Objects.equals(this.value, o.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("value", (Object)this.value).toString();
        }
    }
}

