/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsonArrayElement
extends Node {
    private final Expression value;
    private final Optional<JsonPathParameter.JsonFormat> format;

    public JsonArrayElement(NodeLocation location, Expression value, Optional<JsonPathParameter.JsonFormat> format) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(format, "format is null");
        this.value = value;
        this.format = format;
    }

    public JsonArrayElement(Optional<NodeLocation> location, Expression value, Optional<JsonPathParameter.JsonFormat> format) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(format, "format is null");
        this.value = value;
        this.format = format;
    }

    public Expression getValue() {
        return this.value;
    }

    public Optional<JsonPathParameter.JsonFormat> getFormat() {
        return this.format;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJsonArrayElement(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArrayElement that = (JsonArrayElement)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.format, that.format);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.format);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("format", this.format).omitNullValues().toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!JsonArrayElement.sameClass(this, other)) {
            return false;
        }
        return this.format.equals(((JsonArrayElement)other).format);
    }
}

