/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.RoutineCharacteristic;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SecurityCharacteristic
extends RoutineCharacteristic {
    private final Security security;

    public SecurityCharacteristic(NodeLocation location, Security security) {
        super(Optional.of(location));
        this.security = Objects.requireNonNull(security, "security is null");
    }

    public Security getSecurity() {
        return this.security;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSecurityCharacteristic(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SecurityCharacteristic)) return false;
        SecurityCharacteristic other = (SecurityCharacteristic)obj;
        if (this.security != other.security) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.security.hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("security", (Object)this.security).toString();
    }

    public static enum Security {
        INVOKER,
        DEFINER;

    }
}

