/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.SaveMode;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateTableAsSelect
extends Statement {
    private final QualifiedName name;
    private final Query query;
    private final SaveMode saveMode;
    private final List<Property> properties;
    private final boolean withData;
    private final Optional<List<Identifier>> columnAliases;
    private final Optional<String> comment;

    public CreateTableAsSelect(QualifiedName name, Query query, SaveMode saveMode, List<Property> properties, boolean withData, Optional<List<Identifier>> columnAliases, Optional<String> comment) {
        this(Optional.empty(), name, query, saveMode, properties, withData, columnAliases, comment);
    }

    public CreateTableAsSelect(NodeLocation location, QualifiedName name, Query query, SaveMode saveMode, List<Property> properties, boolean withData, Optional<List<Identifier>> columnAliases, Optional<String> comment) {
        this(Optional.of(location), name, query, saveMode, properties, withData, columnAliases, comment);
    }

    private CreateTableAsSelect(Optional<NodeLocation> location, QualifiedName name, Query query, SaveMode saveMode, List<Property> properties, boolean withData, Optional<List<Identifier>> columnAliases, Optional<String> comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.saveMode = Objects.requireNonNull(saveMode, "saveMode is null");
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
        this.withData = withData;
        this.columnAliases = columnAliases;
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public boolean isWithData() {
        return this.withData;
    }

    public Optional<List<Identifier>> getColumnAliases() {
        return this.columnAliases;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTableAsSelect(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().add((Object)this.query).addAll(this.properties).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.query, this.saveMode, this.properties, this.withData, this.columnAliases, this.comment});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateTableAsSelect o = (CreateTableAsSelect)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && this.saveMode == o.saveMode && Objects.equals(this.properties, o.properties) && this.withData == o.withData && Objects.equals(this.columnAliases, o.columnAliases) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("saveMode", (Object)this.saveMode).add("properties", this.properties).add("withData", this.withData).add("columnAliases", this.columnAliases).add("comment", this.comment).toString();
    }
}

