/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.CharMatcher;
import com.google.common.io.BaseEncoding;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class BinaryLiteral
extends Literal {
    private static final CharMatcher WHITESPACE_MATCHER = CharMatcher.whitespace();
    private static final CharMatcher HEX_DIGIT_MATCHER = CharMatcher.inRange((char)'A', (char)'F').or(CharMatcher.inRange((char)'0', (char)'9')).precomputed();
    private final byte[] value;

    public BinaryLiteral(NodeLocation location, String value) {
        super(Optional.of(location));
        Objects.requireNonNull(value, "value is null");
        String hexString = WHITESPACE_MATCHER.removeFrom((CharSequence)value).toUpperCase(Locale.ENGLISH);
        if (!HEX_DIGIT_MATCHER.matchesAllOf((CharSequence)hexString)) {
            throw new ParsingException("Binary literal can only contain hexadecimal digits", location);
        }
        if (hexString.length() % 2 != 0) {
            throw new ParsingException("Binary literal must contain an even number of digits", location);
        }
        this.value = BaseEncoding.base16().decode((CharSequence)hexString);
    }

    public String toHexString() {
        return BaseEncoding.base16().encode(this.value);
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBinaryLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryLiteral that = (BinaryLiteral)o;
        return Arrays.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!BinaryLiteral.sameClass(this, other)) {
            return false;
        }
        return Arrays.equals(this.value, ((BinaryLiteral)other).value);
    }
}

