/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SetRole
extends Statement {
    private final Type type;
    private final Optional<Identifier> role;
    private final Optional<Identifier> catalog;

    public SetRole(NodeLocation location, Type type, Optional<Identifier> role, Optional<Identifier> catalog) {
        super(Optional.of(location));
        this.type = Objects.requireNonNull(type, "type is null");
        this.role = Objects.requireNonNull(role, "role is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Identifier> getRole() {
        return this.role;
    }

    public Optional<Identifier> getCatalog() {
        return this.catalog;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetRole(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetRole setRole = (SetRole)o;
        return this.type == setRole.type && Objects.equals(this.role, setRole.role) && Objects.equals(this.catalog, setRole.catalog);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.role, this.catalog});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("role", this.role).add("catalog", this.catalog).toString();
    }

    public static enum Type {
        ROLE,
        ALL,
        NONE;

    }
}

