/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.Table;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class RefreshMaterializedView
extends Statement {
    private final Table table;

    public RefreshMaterializedView(NodeLocation location, Table table) {
        super(Optional.of(location));
        this.table = Objects.requireNonNull(table, "name is null");
    }

    public Table getTable() {
        return this.table;
    }

    public QualifiedName getName() {
        return this.table.getName();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRefreshMaterializedView(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RefreshMaterializedView o = (RefreshMaterializedView)obj;
        return Objects.equals(this.table, o.table);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).toString();
    }
}

