/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CallArgument
extends Node {
    private final Optional<Identifier> name;
    private final Expression value;

    public CallArgument(NodeLocation location, Optional<Identifier> name, Expression value) {
        super(Optional.of(location));
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public Optional<Identifier> getName() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCallArgument(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CallArgument o = (CallArgument)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.value, o.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", this.name.orElse(null)).add("value", (Object)this.value).omitNullValues().toString();
    }
}

