/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DropSchema
extends Statement {
    private final QualifiedName schemaName;
    private final boolean exists;
    private final boolean cascade;

    public DropSchema(NodeLocation location, QualifiedName schemaName, boolean exists, boolean cascade) {
        super(Optional.of(location));
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.exists = exists;
        this.cascade = cascade;
    }

    public QualifiedName getSchemaName() {
        return this.schemaName;
    }

    public boolean isExists() {
        return this.exists;
    }

    public boolean isCascade() {
        return this.cascade;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropSchema(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropSchema o = (DropSchema)obj;
        return Objects.equals(this.schemaName, o.schemaName) && this.exists == o.exists && this.cascade == o.cascade;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schemaName, this.exists);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("exists", this.exists).add("cascade", this.cascade).toString();
    }
}

