/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.RoutineCharacteristic;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CommentCharacteristic
extends RoutineCharacteristic {
    private final String comment;

    public CommentCharacteristic(NodeLocation location, String comment) {
        super(Optional.of(location));
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCommentCharacteristic(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CommentCharacteristic)) return false;
        CommentCharacteristic other = (CommentCharacteristic)obj;
        if (!this.comment.equals(other.comment)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.comment.hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("comment", (Object)this.comment).toString();
    }
}

