/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.PatternSearchMode;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SubsetDefinition;
import io.trino.sql.tree.VariableDefinition;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PatternRecognitionRelation
extends Relation {
    private final Relation input;
    private final List<Expression> partitionBy;
    private final Optional<OrderBy> orderBy;
    private final List<MeasureDefinition> measures;
    private final Optional<RowsPerMatch> rowsPerMatch;
    private final Optional<SkipTo> afterMatchSkipTo;
    private final Optional<PatternSearchMode> patternSearchMode;
    private final RowPattern pattern;
    private final List<SubsetDefinition> subsets;
    private final List<VariableDefinition> variableDefinitions;

    public PatternRecognitionRelation(Relation input, List<Expression> partitionBy, Optional<OrderBy> orderBy, List<MeasureDefinition> measures, Optional<RowsPerMatch> rowsPerMatch, Optional<SkipTo> afterMatchSkipTo, Optional<PatternSearchMode> patternSearchMode, RowPattern pattern, List<SubsetDefinition> subsets, List<VariableDefinition> variableDefinitions) {
        this(Optional.empty(), input, partitionBy, orderBy, measures, rowsPerMatch, afterMatchSkipTo, patternSearchMode, pattern, subsets, variableDefinitions);
    }

    public PatternRecognitionRelation(NodeLocation location, Relation input, List<Expression> partitionBy, Optional<OrderBy> orderBy, List<MeasureDefinition> measures, Optional<RowsPerMatch> rowsPerMatch, Optional<SkipTo> afterMatchSkipTo, Optional<PatternSearchMode> patternSearchMode, RowPattern pattern, List<SubsetDefinition> subsets, List<VariableDefinition> variableDefinitions) {
        this(Optional.of(location), input, partitionBy, orderBy, measures, rowsPerMatch, afterMatchSkipTo, patternSearchMode, pattern, subsets, variableDefinitions);
    }

    private PatternRecognitionRelation(Optional<NodeLocation> location, Relation input, List<Expression> partitionBy, Optional<OrderBy> orderBy, List<MeasureDefinition> measures, Optional<RowsPerMatch> rowsPerMatch, Optional<SkipTo> afterMatchSkipTo, Optional<PatternSearchMode> patternSearchMode, RowPattern pattern, List<SubsetDefinition> subsets, List<VariableDefinition> variableDefinitions) {
        super(location);
        this.input = Objects.requireNonNull(input, "input is null");
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        this.measures = Objects.requireNonNull(measures, "measures is null");
        this.rowsPerMatch = Objects.requireNonNull(rowsPerMatch, "rowsPerMatch is null");
        this.afterMatchSkipTo = Objects.requireNonNull(afterMatchSkipTo, "afterMatchSkipTo is null");
        this.patternSearchMode = Objects.requireNonNull(patternSearchMode, "patternSearchMode is null");
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.subsets = Objects.requireNonNull(subsets, "subsets is null");
        Objects.requireNonNull(variableDefinitions, "variableDefinitions is null");
        Preconditions.checkArgument((!variableDefinitions.isEmpty() ? 1 : 0) != 0, (Object)"variableDefinitions is empty");
        this.variableDefinitions = variableDefinitions;
    }

    public Relation getInput() {
        return this.input;
    }

    public List<Expression> getPartitionBy() {
        return this.partitionBy;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public List<MeasureDefinition> getMeasures() {
        return this.measures;
    }

    public Optional<RowsPerMatch> getRowsPerMatch() {
        return this.rowsPerMatch;
    }

    public Optional<SkipTo> getAfterMatchSkipTo() {
        return this.afterMatchSkipTo;
    }

    public Optional<PatternSearchMode> getPatternSearchMode() {
        return this.patternSearchMode;
    }

    public RowPattern getPattern() {
        return this.pattern;
    }

    public List<SubsetDefinition> getSubsets() {
        return this.subsets;
    }

    public List<VariableDefinition> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPatternRecognitionRelation(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.input);
        builder.addAll(this.partitionBy);
        this.orderBy.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        builder.addAll(this.measures);
        this.afterMatchSkipTo.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        builder.add((Object)this.pattern).addAll(this.subsets).addAll(this.variableDefinitions);
        this.patternSearchMode.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("input", (Object)this.input).add("partitionBy", this.partitionBy).add("orderBy", this.orderBy.orElse(null)).add("measures", this.measures).add("rowsPerMatch", this.rowsPerMatch.orElse(null)).add("afterMatchSkipTo", this.afterMatchSkipTo).add("patternSearchMode", this.patternSearchMode.orElse(null)).add("pattern", (Object)this.pattern).add("subsets", this.subsets).add("variableDefinitions", this.variableDefinitions).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternRecognitionRelation that = (PatternRecognitionRelation)o;
        return Objects.equals(this.input, that.input) && Objects.equals(this.partitionBy, that.partitionBy) && Objects.equals(this.orderBy, that.orderBy) && Objects.equals(this.measures, that.measures) && Objects.equals(this.rowsPerMatch, that.rowsPerMatch) && Objects.equals(this.afterMatchSkipTo, that.afterMatchSkipTo) && Objects.equals(this.patternSearchMode, that.patternSearchMode) && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.subsets, that.subsets) && Objects.equals(this.variableDefinitions, that.variableDefinitions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.input, this.partitionBy, this.orderBy, this.measures, this.rowsPerMatch, this.afterMatchSkipTo, this.patternSearchMode, this.pattern, this.subsets, this.variableDefinitions);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!PatternRecognitionRelation.sameClass(this, other)) {
            return false;
        }
        return this.rowsPerMatch.equals(((PatternRecognitionRelation)other).rowsPerMatch);
    }

    public static enum RowsPerMatch {
        ONE,
        ALL_SHOW_EMPTY,
        ALL_OMIT_EMPTY,
        ALL_WITH_UNMATCHED,
        WINDOW;

    }
}

