/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SaveMode;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.TableElement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateTable
extends Statement {
    private final QualifiedName name;
    private final List<TableElement> elements;
    private final SaveMode saveMode;
    private final List<Property> properties;
    private final Optional<String> comment;

    public CreateTable(QualifiedName name, List<TableElement> elements, SaveMode saveMode, List<Property> properties, Optional<String> comment) {
        this(Optional.empty(), name, elements, saveMode, properties, comment);
    }

    public CreateTable(NodeLocation location, QualifiedName name, List<TableElement> elements, SaveMode saveMode, List<Property> properties, Optional<String> comment) {
        this(Optional.of(location), name, elements, saveMode, properties, comment);
    }

    private CreateTable(Optional<NodeLocation> location, QualifiedName name, List<TableElement> elements, SaveMode saveMode, List<Property> properties, Optional<String> comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.elements = ImmutableList.copyOf((Collection)Objects.requireNonNull(elements, "elements is null"));
        this.saveMode = Objects.requireNonNull(saveMode, "saveMode is null");
        this.properties = Objects.requireNonNull(properties, "properties is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<TableElement> getElements() {
        return this.elements;
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().addAll(this.elements).addAll(this.properties).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.elements, this.saveMode, this.properties, this.comment});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateTable o = (CreateTable)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.elements, o.elements) && Objects.equals((Object)this.saveMode, (Object)o.saveMode) && Objects.equals(this.properties, o.properties) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("elements", this.elements).add("saveMode", (Object)this.saveMode).add("properties", this.properties).add("comment", this.comment).toString();
    }
}

