/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RenameColumn
extends Statement {
    private final QualifiedName table;
    private final QualifiedName source;
    private final Identifier target;
    private final boolean tableExists;
    private final boolean columnExists;

    public RenameColumn(NodeLocation location, QualifiedName table, QualifiedName source, Identifier target, boolean tableExists, boolean columnExists) {
        super(Optional.of(location));
        this.table = Objects.requireNonNull(table, "table is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.tableExists = tableExists;
        this.columnExists = columnExists;
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public QualifiedName getSource() {
        return this.source;
    }

    public Identifier getTarget() {
        return this.target;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public boolean isColumnExists() {
        return this.columnExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRenameColumn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenameColumn that = (RenameColumn)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.source, this.target);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("source", (Object)this.source).add("target", (Object)this.target).toString();
    }
}

