/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class WhileStatement
extends ControlStatement {
    private final Optional<Identifier> label;
    private final Expression expression;
    private final List<ControlStatement> statements;

    public WhileStatement(NodeLocation location, Optional<Identifier> label, Expression expression, List<ControlStatement> statements) {
        super(location);
        this.label = Objects.requireNonNull(label, "label is null");
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.statements = Objects.requireNonNull(statements, "statements is null");
    }

    public Optional<Identifier> getLabel() {
        return this.label;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<ControlStatement> getStatements() {
        return this.statements;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWhileStatement(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.builder().add((Object)this.expression).addAll(this.statements).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WhileStatement)) return false;
        WhileStatement other = (WhileStatement)obj;
        if (!Objects.equals(this.label, other.label)) return false;
        if (!Objects.equals(this.expression, other.expression)) return false;
        if (!Objects.equals(this.statements, other.statements)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.label, this.expression, this.statements);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("label", this.label).add("expression", (Object)this.expression).add("statements", this.statements).toString();
    }
}

