/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.Preconditions;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DescriptorField;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class Descriptor
extends Node {
    private final List<DescriptorField> fields;

    public Descriptor(NodeLocation location, List<DescriptorField> fields) {
        super(Optional.of(location));
        Objects.requireNonNull(fields, "fields is null");
        Preconditions.checkArgument((!fields.isEmpty() ? 1 : 0) != 0, (Object)"fields list is empty");
        this.fields = fields;
    }

    public List<DescriptorField> getFields() {
        return this.fields;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDescriptor(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.fields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.fields, ((Descriptor)o).fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fields);
    }

    @Override
    public String toString() {
        return this.fields.stream().map(DescriptorField::toString).collect(Collectors.joining(", ", "DESCRIPTOR(", ")"));
    }

    @Override
    public boolean shallowEquals(Node o) {
        return Descriptor.sameClass(this, o);
    }
}

