/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonTableColumnDefinition;
import io.trino.sql.tree.JsonTablePlan;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Relation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class JsonTable
extends Relation {
    private final JsonPathInvocation jsonPathInvocation;
    private final List<JsonTableColumnDefinition> columns;
    private final Optional<JsonTablePlan> plan;
    private final Optional<ErrorBehavior> errorBehavior;

    public JsonTable(NodeLocation location, JsonPathInvocation jsonPathInvocation, List<JsonTableColumnDefinition> columns, Optional<JsonTablePlan> plan, Optional<ErrorBehavior> errorBehavior) {
        super(Optional.of(location));
        this.jsonPathInvocation = Objects.requireNonNull(jsonPathInvocation, "jsonPathInvocation is null");
        this.columns = ImmutableList.copyOf(columns);
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"columns is empty");
        this.plan = Objects.requireNonNull(plan, "plan is null");
        this.errorBehavior = Objects.requireNonNull(errorBehavior, "errorBehavior is null");
    }

    public JsonPathInvocation getJsonPathInvocation() {
        return this.jsonPathInvocation;
    }

    public List<JsonTableColumnDefinition> getColumns() {
        return this.columns;
    }

    public Optional<JsonTablePlan> getPlan() {
        return this.plan;
    }

    public Optional<ErrorBehavior> getErrorBehavior() {
        return this.errorBehavior;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJsonTable(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder();
        children.add((Object)this.jsonPathInvocation);
        children.addAll(this.columns);
        this.plan.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        return children.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jsonPathInvocation", (Object)this.jsonPathInvocation).add("columns", this.columns).add("plan", this.plan.orElse(null)).add("errorBehavior", this.errorBehavior.orElse(null)).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JsonTable o = (JsonTable)obj;
        return Objects.equals(this.jsonPathInvocation, o.jsonPathInvocation) && Objects.equals(this.columns, o.columns) && Objects.equals(this.plan, o.plan) && Objects.equals(this.errorBehavior, o.errorBehavior);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.jsonPathInvocation, this.columns, this.plan, this.errorBehavior);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!JsonTable.sameClass(this, other)) {
            return false;
        }
        JsonTable otherNode = (JsonTable)other;
        return Objects.equals(this.errorBehavior, otherNode.errorBehavior);
    }

    public static enum ErrorBehavior {
        ERROR,
        EMPTY;

    }
}

