/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryPeriod
extends Node {
    private final Optional<Expression> start;
    private final Optional<Expression> end;
    private final RangeType rangeType;

    public QueryPeriod(NodeLocation location, RangeType rangeType, Expression end) {
        this(location, rangeType, Optional.empty(), Optional.of(end));
    }

    private QueryPeriod(NodeLocation location, RangeType rangeType, Optional<Expression> start, Optional<Expression> end) {
        super(Optional.of(location));
        this.rangeType = Objects.requireNonNull(rangeType, "rangeType is null");
        this.start = start;
        this.end = end;
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.start.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.end.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    public Optional<Expression> getStart() {
        return this.start;
    }

    public Optional<Expression> getEnd() {
        return this.end;
    }

    public RangeType getRangeType() {
        return this.rangeType;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQueryPeriod(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryPeriod o = (QueryPeriod)obj;
        return Objects.equals((Object)this.rangeType, (Object)o.rangeType) && Objects.equals(this.start, o.start) && Objects.equals(this.end, o.end);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.rangeType, this.start, this.end});
    }

    @Override
    public String toString() {
        return "FOR " + this.rangeType.toString() + " AS OF " + this.end.get().toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!QueryPeriod.sameClass(this, other)) {
            return false;
        }
        return this.rangeType.equals((Object)((QueryPeriod)other).rangeType);
    }

    public static enum RangeType {
        TIMESTAMP,
        VERSION;

    }
}

