/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.jsonpath;

import com.google.common.collect.ImmutableList;
import io.trino.jsonpath.JsonPathBaseVisitor;
import io.trino.jsonpath.JsonPathParser;
import io.trino.sql.jsonpath.tree.AbsMethod;
import io.trino.sql.jsonpath.tree.ArithmeticBinary;
import io.trino.sql.jsonpath.tree.ArithmeticUnary;
import io.trino.sql.jsonpath.tree.ArrayAccessor;
import io.trino.sql.jsonpath.tree.CeilingMethod;
import io.trino.sql.jsonpath.tree.ComparisonPredicate;
import io.trino.sql.jsonpath.tree.ConjunctionPredicate;
import io.trino.sql.jsonpath.tree.ContextVariable;
import io.trino.sql.jsonpath.tree.DatetimeMethod;
import io.trino.sql.jsonpath.tree.DescendantMemberAccessor;
import io.trino.sql.jsonpath.tree.DisjunctionPredicate;
import io.trino.sql.jsonpath.tree.DoubleMethod;
import io.trino.sql.jsonpath.tree.ExistsPredicate;
import io.trino.sql.jsonpath.tree.Filter;
import io.trino.sql.jsonpath.tree.FloorMethod;
import io.trino.sql.jsonpath.tree.IsUnknownPredicate;
import io.trino.sql.jsonpath.tree.JsonNullLiteral;
import io.trino.sql.jsonpath.tree.JsonPath;
import io.trino.sql.jsonpath.tree.KeyValueMethod;
import io.trino.sql.jsonpath.tree.LastIndexVariable;
import io.trino.sql.jsonpath.tree.LikeRegexPredicate;
import io.trino.sql.jsonpath.tree.MemberAccessor;
import io.trino.sql.jsonpath.tree.NamedVariable;
import io.trino.sql.jsonpath.tree.NegationPredicate;
import io.trino.sql.jsonpath.tree.PathNode;
import io.trino.sql.jsonpath.tree.Predicate;
import io.trino.sql.jsonpath.tree.PredicateCurrentItemVariable;
import io.trino.sql.jsonpath.tree.SizeMethod;
import io.trino.sql.jsonpath.tree.SqlValueLiteral;
import io.trino.sql.jsonpath.tree.StartsWithPredicate;
import io.trino.sql.jsonpath.tree.TypeMethod;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class PathTreeBuilder
extends JsonPathBaseVisitor<PathNode> {
    @Override
    public PathNode visitPath(JsonPathParser.PathContext context) {
        boolean lax = context.pathMode().LAX() != null;
        PathNode path = (PathNode)this.visit((ParseTree)context.pathExpression());
        return new JsonPath(lax, path);
    }

    @Override
    public PathNode visitDecimalLiteral(JsonPathParser.DecimalLiteralContext context) {
        return new SqlValueLiteral(new DecimalLiteral(context.getText()));
    }

    @Override
    public PathNode visitDoubleLiteral(JsonPathParser.DoubleLiteralContext context) {
        return new SqlValueLiteral(new DoubleLiteral(context.getText()));
    }

    @Override
    public PathNode visitIntegerLiteral(JsonPathParser.IntegerLiteralContext context) {
        return new SqlValueLiteral(new LongLiteral(context.getText()));
    }

    @Override
    public PathNode visitStringLiteral(JsonPathParser.StringLiteralContext context) {
        return new SqlValueLiteral(new StringLiteral(PathTreeBuilder.unquote(context.STRING().getText())));
    }

    private static String unquote(String quoted) {
        return quoted.substring(1, quoted.length() - 1).replace("\"\"", "\"");
    }

    @Override
    public PathNode visitNullLiteral(JsonPathParser.NullLiteralContext context) {
        return JsonNullLiteral.JSON_NULL;
    }

    @Override
    public PathNode visitBooleanLiteral(JsonPathParser.BooleanLiteralContext context) {
        return new SqlValueLiteral(new BooleanLiteral(context.getText()));
    }

    @Override
    public PathNode visitContextVariable(JsonPathParser.ContextVariableContext context) {
        return new ContextVariable();
    }

    @Override
    public PathNode visitNamedVariable(JsonPathParser.NamedVariableContext context) {
        return PathTreeBuilder.namedVariable(context.NAMED_VARIABLE());
    }

    private static NamedVariable namedVariable(TerminalNode namedVariable) {
        return new NamedVariable(namedVariable.getText().substring(1));
    }

    @Override
    public PathNode visitLastIndexVariable(JsonPathParser.LastIndexVariableContext context) {
        return new LastIndexVariable();
    }

    @Override
    public PathNode visitPredicateCurrentItemVariable(JsonPathParser.PredicateCurrentItemVariableContext context) {
        return new PredicateCurrentItemVariable();
    }

    @Override
    public PathNode visitParenthesizedPath(JsonPathParser.ParenthesizedPathContext context) {
        return (PathNode)this.visit((ParseTree)context.pathExpression());
    }

    @Override
    public PathNode visitMemberAccessor(JsonPathParser.MemberAccessorContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        Optional<Object> key = Optional.empty();
        if (context.stringLiteral() != null) {
            key = Optional.of(PathTreeBuilder.unquote(context.stringLiteral().getText()));
        } else if (context.identifier() != null) {
            key = Optional.of(context.identifier().getText());
        }
        return new MemberAccessor(base, key);
    }

    @Override
    public PathNode visitWildcardMemberAccessor(JsonPathParser.WildcardMemberAccessorContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        return new MemberAccessor(base, Optional.empty());
    }

    @Override
    public PathNode visitDescendantMemberAccessor(JsonPathParser.DescendantMemberAccessorContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        String key = context.stringLiteral() != null ? PathTreeBuilder.unquote(context.stringLiteral().getText()) : context.identifier().getText();
        return new DescendantMemberAccessor(base, key);
    }

    @Override
    public PathNode visitArrayAccessor(JsonPathParser.ArrayAccessorContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        ImmutableList.Builder subscripts = ImmutableList.builder();
        for (JsonPathParser.SubscriptContext subscript : context.subscript()) {
            if (subscript.singleton != null) {
                subscripts.add((Object)new ArrayAccessor.Subscript((PathNode)this.visit((ParseTree)subscript.singleton)));
                continue;
            }
            subscripts.add((Object)new ArrayAccessor.Subscript((PathNode)this.visit((ParseTree)subscript.from), (PathNode)this.visit((ParseTree)subscript.to)));
        }
        return new ArrayAccessor(base, (List<ArrayAccessor.Subscript>)subscripts.build());
    }

    @Override
    public PathNode visitWildcardArrayAccessor(JsonPathParser.WildcardArrayAccessorContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        return new ArrayAccessor(base, (List<ArrayAccessor.Subscript>)ImmutableList.of());
    }

    @Override
    public PathNode visitFilter(JsonPathParser.FilterContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        Predicate predicate = (Predicate)this.visit((ParseTree)context.predicate());
        return new Filter(base, predicate);
    }

    @Override
    public PathNode visitTypeMethod(JsonPathParser.TypeMethodContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        return new TypeMethod(base);
    }

    @Override
    public PathNode visitSizeMethod(JsonPathParser.SizeMethodContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        return new SizeMethod(base);
    }

    @Override
    public PathNode visitDoubleMethod(JsonPathParser.DoubleMethodContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        return new DoubleMethod(base);
    }

    @Override
    public PathNode visitCeilingMethod(JsonPathParser.CeilingMethodContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        return new CeilingMethod(base);
    }

    @Override
    public PathNode visitFloorMethod(JsonPathParser.FloorMethodContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        return new FloorMethod(base);
    }

    @Override
    public PathNode visitAbsMethod(JsonPathParser.AbsMethodContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        return new AbsMethod(base);
    }

    @Override
    public PathNode visitDatetimeMethod(JsonPathParser.DatetimeMethodContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        Optional<String> format = Optional.empty();
        if (context.stringLiteral() != null) {
            format = Optional.of(PathTreeBuilder.unquote(context.stringLiteral().getText()));
        }
        return new DatetimeMethod(base, format);
    }

    @Override
    public PathNode visitKeyValueMethod(JsonPathParser.KeyValueMethodContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.accessorExpression());
        return new KeyValueMethod(base);
    }

    @Override
    public PathNode visitSignedUnary(JsonPathParser.SignedUnaryContext context) {
        PathNode base = (PathNode)this.visit((ParseTree)context.pathExpression());
        return new ArithmeticUnary(PathTreeBuilder.getSign(context.sign.getText()), base);
    }

    private static ArithmeticUnary.Sign getSign(String operator) {
        switch (operator) {
            case "+": {
                return ArithmeticUnary.Sign.PLUS;
            }
            case "-": {
                return ArithmeticUnary.Sign.MINUS;
            }
        }
        throw new UnsupportedOperationException("unexpected unary operator: " + operator);
    }

    @Override
    public PathNode visitBinary(JsonPathParser.BinaryContext context) {
        PathNode left = (PathNode)this.visit((ParseTree)context.left);
        PathNode right = (PathNode)this.visit((ParseTree)context.right);
        return new ArithmeticBinary(PathTreeBuilder.getOperator(context.operator.getText()), left, right);
    }

    private static ArithmeticBinary.Operator getOperator(String operator) {
        switch (operator) {
            case "+": {
                return ArithmeticBinary.Operator.ADD;
            }
            case "-": {
                return ArithmeticBinary.Operator.SUBTRACT;
            }
            case "*": {
                return ArithmeticBinary.Operator.MULTIPLY;
            }
            case "/": {
                return ArithmeticBinary.Operator.DIVIDE;
            }
            case "%": {
                return ArithmeticBinary.Operator.MODULUS;
            }
        }
        throw new UnsupportedOperationException("unexpected binary operator: " + operator);
    }

    @Override
    public PathNode visitComparisonPredicate(JsonPathParser.ComparisonPredicateContext context) {
        PathNode left = (PathNode)this.visit((ParseTree)context.left);
        PathNode right = (PathNode)this.visit((ParseTree)context.right);
        return new ComparisonPredicate(PathTreeBuilder.getComparisonOperator(context.comparisonOperator().getText()), left, right);
    }

    private static ComparisonPredicate.Operator getComparisonOperator(String operator) {
        switch (operator) {
            case "==": {
                return ComparisonPredicate.Operator.EQUAL;
            }
            case "<>": 
            case "!=": {
                return ComparisonPredicate.Operator.NOT_EQUAL;
            }
            case "<": {
                return ComparisonPredicate.Operator.LESS_THAN;
            }
            case ">": {
                return ComparisonPredicate.Operator.GREATER_THAN;
            }
            case "<=": {
                return ComparisonPredicate.Operator.LESS_THAN_OR_EQUAL;
            }
            case ">=": {
                return ComparisonPredicate.Operator.GREATER_THAN_OR_EQUAL;
            }
        }
        throw new UnsupportedOperationException("unexpected comparison operator: " + operator);
    }

    @Override
    public PathNode visitConjunctionPredicate(JsonPathParser.ConjunctionPredicateContext context) {
        Predicate left = (Predicate)this.visit((ParseTree)context.left);
        Predicate right = (Predicate)this.visit((ParseTree)context.right);
        return new ConjunctionPredicate(left, right);
    }

    @Override
    public PathNode visitDisjunctionPredicate(JsonPathParser.DisjunctionPredicateContext context) {
        Predicate left = (Predicate)this.visit((ParseTree)context.left);
        Predicate right = (Predicate)this.visit((ParseTree)context.right);
        return new DisjunctionPredicate(left, right);
    }

    @Override
    public PathNode visitExistsPredicate(JsonPathParser.ExistsPredicateContext context) {
        PathNode path = (PathNode)this.visit((ParseTree)context.pathExpression());
        return new ExistsPredicate(path);
    }

    @Override
    public PathNode visitIsUnknownPredicate(JsonPathParser.IsUnknownPredicateContext context) {
        Predicate predicate = (Predicate)this.visit((ParseTree)context.predicate());
        return new IsUnknownPredicate(predicate);
    }

    @Override
    public PathNode visitLikeRegexPredicate(JsonPathParser.LikeRegexPredicateContext context) {
        PathNode path = (PathNode)this.visit((ParseTree)context.base);
        String pattern = PathTreeBuilder.unquote(context.pattern.getText());
        Optional<String> flag = Optional.empty();
        if (context.flag != null) {
            flag = Optional.of(PathTreeBuilder.unquote(context.flag.getText()));
        }
        return new LikeRegexPredicate(path, pattern, flag);
    }

    @Override
    public PathNode visitNegationPredicate(JsonPathParser.NegationPredicateContext context) {
        Predicate predicate = (Predicate)this.visit((ParseTree)context.delimitedPredicate());
        return new NegationPredicate(predicate);
    }

    @Override
    public PathNode visitParenthesizedPredicate(JsonPathParser.ParenthesizedPredicateContext context) {
        return (PathNode)this.visit((ParseTree)context.predicate());
    }

    @Override
    public PathNode visitStartsWithPredicate(JsonPathParser.StartsWithPredicateContext context) {
        PathNode whole = (PathNode)this.visit((ParseTree)context.whole);
        PathNode initial = context.string != null ? (PathNode)this.visit((ParseTree)context.string) : PathTreeBuilder.namedVariable(context.NAMED_VARIABLE());
        return new StartsWithPredicate(whole, initial);
    }

    protected PathNode aggregateResult(PathNode aggregate, PathNode nextResult) {
        if (nextResult == null) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if (aggregate == null) {
            return nextResult;
        }
        throw new UnsupportedOperationException("not yet implemented");
    }
}

