/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Property
extends Node {
    private final Identifier name;
    private final Optional<Expression> value;

    public Property(Identifier name) {
        this(Optional.empty(), name, Optional.empty());
    }

    public Property(NodeLocation location, Identifier name) {
        this(Optional.of(Objects.requireNonNull(location, "location is null")), name, Optional.empty());
    }

    public Property(Identifier name, Expression value) {
        this(Optional.empty(), name, Optional.of(Objects.requireNonNull(value, "value is null")));
    }

    public Property(NodeLocation location, Identifier name, Expression value) {
        this(Optional.of(Objects.requireNonNull(location, "location is null")), name, Optional.of(Objects.requireNonNull(value, "value is null")));
    }

    private Property(Optional<NodeLocation> location, Identifier name, Optional<Expression> value) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public boolean isSetToDefault() {
        return !this.value.isPresent();
    }

    public Expression getNonDefaultValue() {
        Preconditions.checkState((!this.isSetToDefault() ? 1 : 0) != 0, (String)"Cannot get non-default value of property %s since its value is set to DEFAULT", (Object)this.name);
        return this.value.get();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitProperty(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.isSetToDefault() ? ImmutableList.of((Object)this.name) : ImmutableList.of((Object)this.name, (Object)this.getNonDefaultValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", this.isSetToDefault() ? "DEFAULT" : this.getNonDefaultValue()).toString();
    }
}

