/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.JsonTablePlan;
import io.trino.sql.tree.JsonTableSpecificPlan;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;

public class PlanSiblings
extends JsonTableSpecificPlan {
    private final JsonTablePlan.SiblingsPlanType type;
    private final List<JsonTableSpecificPlan> siblings;

    public PlanSiblings(NodeLocation location, JsonTablePlan.SiblingsPlanType type, List<JsonTableSpecificPlan> siblings) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.siblings = ImmutableList.copyOf(siblings);
        Preconditions.checkArgument((siblings.size() >= 2 ? 1 : 0) != 0, (Object)("sibling plan must contain at least two siblings, actual: " + siblings.size()));
    }

    public JsonTablePlan.SiblingsPlanType getType() {
        return this.type;
    }

    public List<JsonTableSpecificPlan> getSiblings() {
        return this.siblings;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPlanSiblings(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.siblings;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("siblings", this.siblings).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanSiblings that = (PlanSiblings)o;
        return this.type == that.type && Objects.equals(this.siblings, that.siblings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.siblings});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!PlanSiblings.sameClass(this, other)) {
            return false;
        }
        return this.type == ((PlanSiblings)other).type;
    }
}

