/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsonPathParameter
extends Node {
    private final Identifier name;
    private final Expression parameter;
    private final Optional<JsonFormat> format;

    public JsonPathParameter(Optional<NodeLocation> location, Identifier name, Expression parameter, Optional<JsonFormat> format) {
        super(location);
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(parameter, "parameter is null");
        Objects.requireNonNull(format, "format is null");
        this.name = name;
        this.parameter = parameter;
        this.format = format;
    }

    public Identifier getName() {
        return this.name;
    }

    public Expression getParameter() {
        return this.parameter;
    }

    public Optional<JsonFormat> getFormat() {
        return this.format;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.parameter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPathParameter that = (JsonPathParameter)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.parameter, that.parameter) && Objects.equals(this.format, that.format);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.parameter, this.format);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("parameter", (Object)this.parameter).add("format", this.format).omitNullValues().toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!JsonPathParameter.sameClass(this, other)) {
            return false;
        }
        JsonPathParameter otherRelation = (JsonPathParameter)other;
        return this.name.equals(otherRelation.name) && this.format.equals(otherRelation.format);
    }

    public static enum JsonFormat {
        JSON("JSON"),
        UTF8("JSON ENCODING UTF8"),
        UTF16("JSON ENCODING UTF16"),
        UTF32("JSON ENCODING UTF32");

        private final String name;

        private JsonFormat(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

