/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GroupBy;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LogicalBinaryExpression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QueryBody;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.SingleColumn;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.WhenClause;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class QueryUtil {
    private QueryUtil() {
    }

    public static Identifier identifier(String name) {
        return new Identifier(name);
    }

    public static Identifier quotedIdentifier(String name) {
        return new Identifier(name, true);
    }

    public static SelectItem unaliasedName(String name) {
        return new SingleColumn(QueryUtil.identifier(name));
    }

    public static SelectItem aliasedName(String name, String alias) {
        return new SingleColumn((Expression)QueryUtil.identifier(name), QueryUtil.identifier(alias));
    }

    public static Select selectList(Expression ... expressions) {
        return QueryUtil.selectList(Arrays.asList(expressions));
    }

    public static Select selectList(List<Expression> expressions) {
        ImmutableList.Builder items = ImmutableList.builder();
        for (Expression expression : expressions) {
            items.add((Object)new SingleColumn(expression));
        }
        return new Select(false, (List<SelectItem>)items.build());
    }

    public static Select selectList(SelectItem ... items) {
        return new Select(false, (List<SelectItem>)ImmutableList.copyOf((Object[])items));
    }

    public static Select selectAll(List<SelectItem> items) {
        return new Select(false, items);
    }

    public static Table table(QualifiedName name) {
        return new Table(name);
    }

    public static Relation subquery(Query query) {
        return new TableSubquery(query);
    }

    public static SortItem ascending(String name) {
        return new SortItem(QueryUtil.identifier(name), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED);
    }

    public static Expression logicalAnd(Expression left, Expression right) {
        return new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, left, right);
    }

    public static Expression equal(Expression left, Expression right) {
        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, left, right);
    }

    public static Expression caseWhen(Expression operand, Expression result) {
        return new SearchedCaseExpression((List<WhenClause>)ImmutableList.of((Object)new WhenClause(operand, result)), Optional.empty());
    }

    public static Expression functionCall(String name, Expression ... arguments) {
        return new FunctionCall(QualifiedName.of(name), (List<Expression>)ImmutableList.copyOf((Object[])arguments));
    }

    public static Values values(Row ... row) {
        return new Values((List<Expression>)ImmutableList.copyOf((Object[])row));
    }

    public static Row row(Expression ... values) {
        return new Row((List<Expression>)ImmutableList.copyOf((Object[])values));
    }

    public static Relation aliased(Relation relation, String alias, List<String> columnAliases) {
        return new AliasedRelation(relation, QueryUtil.identifier(alias), columnAliases.stream().map(QueryUtil::identifier).collect(Collectors.toList()));
    }

    public static SelectItem aliasedNullToEmpty(String column, String alias) {
        return new SingleColumn((Expression)new CoalesceExpression(QueryUtil.identifier(column), new StringLiteral(""), new Expression[0]), QueryUtil.identifier(alias));
    }

    public static OrderBy ordering(SortItem ... items) {
        return new OrderBy((List<SortItem>)ImmutableList.copyOf((Object[])items));
    }

    public static Query simpleQuery(Select select) {
        return QueryUtil.query(new QuerySpecification(select, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    public static Query simpleQuery(Select select, Relation from) {
        return QueryUtil.simpleQuery(select, from, Optional.empty(), Optional.empty());
    }

    public static Query simpleQuery(Select select, Relation from, OrderBy orderBy) {
        return QueryUtil.simpleQuery(select, from, Optional.empty(), Optional.of(orderBy));
    }

    public static Query simpleQuery(Select select, Relation from, Expression where) {
        return QueryUtil.simpleQuery(select, from, Optional.of(where), Optional.empty());
    }

    public static Query simpleQuery(Select select, Relation from, Expression where, OrderBy orderBy) {
        return QueryUtil.simpleQuery(select, from, Optional.of(where), Optional.of(orderBy));
    }

    public static Query simpleQuery(Select select, Relation from, Optional<Expression> where, Optional<OrderBy> orderBy) {
        return QueryUtil.simpleQuery(select, from, where, Optional.empty(), Optional.empty(), orderBy, Optional.empty(), Optional.empty());
    }

    public static Query simpleQuery(Select select, Relation from, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        return QueryUtil.query(new QuerySpecification(select, Optional.of(from), where, groupBy, having, orderBy, offset, limit));
    }

    public static Query singleValueQuery(String columnName, String value) {
        Values values = QueryUtil.values(QueryUtil.row(new StringLiteral(value)));
        return QueryUtil.simpleQuery(QueryUtil.selectList(new AllColumns()), QueryUtil.aliased(values, "t", (List<String>)ImmutableList.of((Object)columnName)));
    }

    public static Query singleValueQuery(String columnName, boolean value) {
        Values values = QueryUtil.values(QueryUtil.row(value ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL));
        return QueryUtil.simpleQuery(QueryUtil.selectList(new AllColumns()), QueryUtil.aliased(values, "t", (List<String>)ImmutableList.of((Object)columnName)));
    }

    public static Query query(QueryBody body) {
        return new Query(Optional.empty(), body, Optional.empty(), Optional.empty(), Optional.empty());
    }
}

