/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.expression.ComparisonOperator;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class RewriteStringComparison
implements ConnectorExpressionRule<Call, ParameterizedExpression> {
    private static final Capture<Variable> FIRST_ARGUMENT = Capture.newCapture();
    private static final Capture<Variable> SECOND_ARGUMENT = Capture.newCapture();
    private static final Pattern<Call> PATTERN = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.type().equalTo((Object)BooleanType.BOOLEAN)).with(ConnectorExpressionPatterns.functionName().matching(arg_0 -> ((ImmutableSet)((ImmutableSet)Stream.of(ComparisonOperator.values()).filter(comparison -> comparison != ComparisonOperator.IS_DISTINCT_FROM).map(ComparisonOperator::getFunctionName).collect(ImmutableSet.toImmutableSet()))).contains(arg_0))).with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)2)).with(ConnectorExpressionPatterns.argument((int)0).matching(ConnectorExpressionPatterns.variable().with(ConnectorExpressionPatterns.type().matching(type -> type instanceof CharType || type instanceof VarcharType)).capturedAs(FIRST_ARGUMENT))).with(ConnectorExpressionPatterns.argument((int)1).matching(ConnectorExpressionPatterns.variable().with(ConnectorExpressionPatterns.type().matching(type -> type instanceof CharType || type instanceof VarcharType)).capturedAs(SECOND_ARGUMENT)));

    public Pattern<Call> getPattern() {
        return PATTERN;
    }

    public Optional<ParameterizedExpression> rewrite(Call expression, Captures captures, ConnectorExpressionRule.RewriteContext<ParameterizedExpression> context) {
        ComparisonOperator comparison = ComparisonOperator.forFunctionName((FunctionName)expression.getFunctionName());
        Variable firstArgument = (Variable)captures.get(FIRST_ARGUMENT);
        Variable secondArgument = (Variable)captures.get(SECOND_ARGUMENT);
        if (RewriteStringComparison.isClob(firstArgument, context) || RewriteStringComparison.isClob(secondArgument, context)) {
            return Optional.empty();
        }
        return context.defaultRewrite((ConnectorExpression)firstArgument).flatMap(first -> context.defaultRewrite((ConnectorExpression)secondArgument).map(second -> new ParameterizedExpression("(%s) %s (%s)".formatted(first.expression(), comparison.getOperator(), second.expression()), (List)ImmutableList.builder().addAll((Iterable)first.parameters()).addAll((Iterable)second.parameters()).build())));
    }

    private static boolean isClob(Variable variable, ConnectorExpressionRule.RewriteContext<?> context) {
        return switch (((JdbcColumnHandle)context.getAssignment(variable.getName())).getJdbcTypeHandle().jdbcType()) {
            case 2005, 2011 -> true;
            default -> false;
        };
    }
}

