/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.slice.Slices;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectReadFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.aggregation.ImplementAvgDecimal;
import io.trino.plugin.jdbc.aggregation.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.aggregation.ImplementCount;
import io.trino.plugin.jdbc.aggregation.ImplementCountAll;
import io.trino.plugin.jdbc.aggregation.ImplementCountDistinct;
import io.trino.plugin.jdbc.aggregation.ImplementCovariancePop;
import io.trino.plugin.jdbc.aggregation.ImplementCovarianceSamp;
import io.trino.plugin.jdbc.aggregation.ImplementMinMax;
import io.trino.plugin.jdbc.aggregation.ImplementStddevPop;
import io.trino.plugin.jdbc.aggregation.ImplementStddevSamp;
import io.trino.plugin.jdbc.aggregation.ImplementSum;
import io.trino.plugin.jdbc.aggregation.ImplementVariancePop;
import io.trino.plugin.jdbc.aggregation.ImplementVarianceSamp;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.oracle.OracleConfig;
import io.trino.plugin.oracle.OracleSessionProperties;
import io.trino.plugin.oracle.RewriteStringComparison;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import oracle.jdbc.OraclePreparedStatement;

public class OracleClient
extends BaseJdbcClient {
    public static final int ORACLE_MAX_LIST_EXPRESSIONS = 1000;
    private static final int MAX_ORACLE_TIMESTAMP_PRECISION = 9;
    private static final int MAX_BYTES_PER_CHAR = 4;
    private static final int ORACLE_VARCHAR2_MAX_BYTES = 4000;
    private static final int ORACLE_VARCHAR2_MAX_CHARS = 1000;
    private static final int ORACLE_CHAR_MAX_BYTES = 2000;
    private static final int ORACLE_CHAR_MAX_CHARS = 500;
    private static final int PRECISION_OF_UNSPECIFIED_NUMBER = 127;
    private static final int TRINO_BIGINT_TYPE = 832424001;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    private static final DateTimeFormatter TIMESTAMP_SECONDS_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");
    private static final DateTimeFormatter TIMESTAMP_NANO_OPTIONAL_FORMATTER = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().toFormatter();
    private static final Set<String> INTERNAL_SCHEMAS = ImmutableSet.builder().add((Object)"ctxsys").add((Object)"flows_files").add((Object)"mdsys").add((Object)"outln").add((Object)"sys").add((Object)"system").add((Object)"xdb").add((Object)"xs$null").build();
    private static final Map<Type, WriteMapping> WRITE_MAPPINGS = ImmutableMap.builder().put((Object)BooleanType.BOOLEAN, (Object)OracleClient.oracleBooleanWriteMapping()).put((Object)BigintType.BIGINT, (Object)WriteMapping.longMapping((String)"number(19)", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction())).put((Object)IntegerType.INTEGER, (Object)WriteMapping.longMapping((String)"number(10)", (LongWriteFunction)StandardColumnMappings.integerWriteFunction())).put((Object)SmallintType.SMALLINT, (Object)WriteMapping.longMapping((String)"number(5)", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction())).put((Object)TinyintType.TINYINT, (Object)WriteMapping.longMapping((String)"number(3)", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction())).put((Object)DoubleType.DOUBLE, (Object)WriteMapping.doubleMapping((String)"binary_double", (DoubleWriteFunction)OracleClient.oracleDoubleWriteFunction())).put((Object)RealType.REAL, (Object)WriteMapping.longMapping((String)"binary_float", (LongWriteFunction)OracleClient.oracleRealWriteFunction())).put((Object)VarbinaryType.VARBINARY, (Object)WriteMapping.sliceMapping((String)"blob", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction())).put((Object)DateType.DATE, (Object)WriteMapping.longMapping((String)"date", (LongWriteFunction)OracleClient.trinoDateToOracleDateWriteFunction())).put((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, (Object)WriteMapping.longMapping((String)"timestamp(3) with time zone", (LongWriteFunction)OracleClient.oracleTimestampWithTimeZoneWriteFunction())).buildOrThrow();
    private final boolean synonymsEnabled;
    private final ConnectorExpressionRewriter<ParameterizedExpression> connectorExpressionRewriter;
    private final AggregateFunctionRewriter<JdbcExpression, ?> aggregateFunctionRewriter;

    @Inject
    public OracleClient(BaseJdbcConfig config, OracleConfig oracleConfig, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping, RemoteQueryModifier queryModifier) {
        super("\"", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, queryModifier, true);
        this.synonymsEnabled = oracleConfig.isSynonymsEnabled();
        this.connectorExpressionRewriter = JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((OracleClient)this).quoted(arg_0)).withTypeClass("numeric_type", (Set)ImmutableSet.of((Object)"tinyint", (Object)"smallint", (Object)"integer", (Object)"bigint", (Object)"decimal", (Object)"real", (Object[])new String[]{"double"})).map("$equal(left: numeric_type, right: numeric_type)").to("left = right").map("$not_equal(left: numeric_type, right: numeric_type)").to("left <> right").map("$less_than(left: numeric_type, right: numeric_type)").to("left < right").map("$less_than_or_equal(left: numeric_type, right: numeric_type)").to("left <= right").map("$greater_than(left: numeric_type, right: numeric_type)").to("left > right").map("$greater_than_or_equal(left: numeric_type, right: numeric_type)").to("left >= right").add((ConnectorExpressionRule)new RewriteStringComparison()).build();
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(832424001, Optional.of("NUMBER"), Optional.of(0), Optional.of(0), Optional.empty(), Optional.empty());
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(this.connectorExpressionRewriter, (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementCountDistinct(bigintTypeHandle, true)).add((Object)new ImplementMinMax(true)).add((Object)new ImplementSum(OracleClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementStddevSamp()).add((Object)new ImplementStddevPop()).add((Object)new ImplementVarianceSamp()).add((Object)new ImplementVariancePop()).add((Object)new ImplementCovarianceSamp()).add((Object)new ImplementCovariancePop()).build());
    }

    protected Optional<List<String>> getTableTypes() {
        if (this.synonymsEnabled) {
            return Optional.of(ImmutableList.of((Object)"TABLE", (Object)"VIEW", (Object)"SYNONYM"));
        }
        return Optional.of(ImmutableList.of((Object)"TABLE", (Object)"VIEW"));
    }

    protected boolean filterSchema(String schemaName) {
        if (INTERNAL_SCHEMAS.contains(schemaName.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        return super.filterSchema(schemaName);
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql, Optional<Integer> columnCount) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        if (columnCount.isPresent()) {
            statement.setFetchSize(Math.max(100000 / columnCount.get(), 1000));
        }
        return statement;
    }

    protected void renameTable(ConnectorSession session, Connection connection, String catalogName, String remoteSchemaName, String remoteTableName, String newRemoteSchemaName, String newRemoteTableName) throws SQLException {
        if (!remoteSchemaName.equals(newRemoteSchemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables across schemas");
        }
        String newTableName = newRemoteTableName.toUpperCase(Locale.ENGLISH);
        this.execute(session, connection, String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, remoteSchemaName, remoteTableName), this.quoted(newTableName)));
    }

    public void createSchema(ConnectorSession session, String schemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating schemas");
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping schemas");
    }

    protected void dropTable(ConnectorSession session, RemoteTableName remoteTableName, boolean temporaryTable) {
        String quotedTable = this.quoted(remoteTableName);
        String dropTableSql = "DROP TABLE " + quotedTable;
        try (Connection connection = this.connectionFactory.openConnection(session);){
            if (temporaryTable) {
                connection.setAutoCommit(false);
                this.execute(session, connection, "LOCK TABLE " + quotedTable + " IN EXCLUSIVE MODE");
                dropTableSql = dropTableSql + " PURGE";
            }
            this.execute(session, connection, dropTableSql);
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    public OptionalInt getMaxColumnNameLength(ConnectorSession session) {
        return this.getMaxColumnNameLengthFromDatabaseMetaData(session);
    }

    public Optional<String> getTableComment(ResultSet resultSet) throws SQLException {
        return Optional.ofNullable(Strings.emptyToNull((String)resultSet.getString("REMARKS")));
    }

    protected List<String> createTableSqls(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((boolean)tableMetadata.getProperties().isEmpty(), (String)"Unsupported table properties: %s", (Object)tableMetadata.getProperties());
        ImmutableList.Builder createTableSqlsBuilder = ImmutableList.builder();
        createTableSqlsBuilder.add((Object)String.format("CREATE TABLE %s (%s)", this.quoted(remoteTableName), String.join((CharSequence)", ", columns)));
        Optional tableComment = tableMetadata.getComment();
        if (tableComment.isPresent()) {
            createTableSqlsBuilder.add((Object)this.buildTableCommentSql(remoteTableName, tableComment));
        }
        return createTableSqlsBuilder.build();
    }

    public void setTableComment(ConnectorSession session, JdbcTableHandle handle, Optional<String> comment) {
        this.execute(session, this.buildTableCommentSql(handle.asPlainTable().getRemoteTableName(), comment));
    }

    private String buildTableCommentSql(RemoteTableName remoteTableName, Optional<String> comment) {
        return String.format("COMMENT ON TABLE %s IS %s", this.quoted(remoteTableName), OracleClient.varcharLiteral((String)comment.orElse("")));
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        if (typeHandle.jdbcType() == 832424001) {
            return Optional.of(StandardColumnMappings.bigintColumnMapping());
        }
        String jdbcTypeName = (String)typeHandle.jdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + String.valueOf(typeHandle)));
        Optional mappingToVarchar = this.getForcedMappingToVarchar(typeHandle);
        if (mappingToVarchar.isPresent()) {
            return mappingToVarchar;
        }
        if (jdbcTypeName.equalsIgnoreCase("date")) {
            return Optional.of(ColumnMapping.longMapping((Type)TimestampType.TIMESTAMP_SECONDS, (LongReadFunction)OracleClient.oracleTimestampReadFunction(TimestampType.TIMESTAMP_SECONDS), (LongWriteFunction)OracleClient.trinoTimestampToOracleDateWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN));
        }
        switch (typeHandle.jdbcType()) {
            case 5: {
                return Optional.of(ColumnMapping.longMapping((Type)SmallintType.SMALLINT, ResultSet::getShort, (LongWriteFunction)StandardColumnMappings.smallintWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN));
            }
            case 100: {
                return Optional.of(ColumnMapping.longMapping((Type)RealType.REAL, (resultSet, columnIndex) -> Float.floatToRawIntBits(resultSet.getFloat(columnIndex)), (LongWriteFunction)OracleClient.oracleRealWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN));
            }
            case 6: 
            case 101: {
                return Optional.of(ColumnMapping.doubleMapping((Type)DoubleType.DOUBLE, ResultSet::getDouble, (DoubleWriteFunction)OracleClient.oracleDoubleWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN));
            }
            case 2: {
                int actualPrecision = typeHandle.requiredColumnSize();
                int decimalDigits = typeHandle.requiredDecimalDigits();
                int precision = actualPrecision + Math.max(-decimalDigits, 0);
                int scale = Math.max(decimalDigits, 0);
                Optional<Integer> numberDefaultScale = OracleSessionProperties.getNumberDefaultScale(session);
                RoundingMode roundingMode = OracleSessionProperties.getNumberRoundingMode(session);
                if (precision < scale) {
                    if (roundingMode == RoundingMode.UNNECESSARY) break;
                    precision = scale = Math.min(38, scale);
                } else if (numberDefaultScale.isPresent() && precision == 127) {
                    precision = 38;
                    scale = numberDefaultScale.get();
                } else if (precision > 38 || actualPrecision <= 0) break;
                DecimalType decimalType = DecimalType.createDecimalType((int)precision, (int)scale);
                if (decimalType.isShort()) {
                    return Optional.of(ColumnMapping.longMapping((Type)decimalType, (LongReadFunction)StandardColumnMappings.shortDecimalReadFunction((DecimalType)decimalType, (RoundingMode)roundingMode), (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN));
                }
                return Optional.of(ColumnMapping.objectMapping((Type)decimalType, (ObjectReadFunction)StandardColumnMappings.longDecimalReadFunction((DecimalType)decimalType, (RoundingMode)roundingMode), (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN));
            }
            case -15: 
            case 1: {
                CharType charType = CharType.createCharType((int)typeHandle.requiredColumnSize());
                return Optional.of(ColumnMapping.sliceMapping((Type)charType, (SliceReadFunction)StandardColumnMappings.charReadFunction((CharType)charType), (SliceWriteFunction)this.oracleCharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN));
            }
            case -9: 
            case 12: {
                return Optional.of(ColumnMapping.sliceMapping((Type)VarcharType.createVarcharType((int)typeHandle.requiredColumnSize()), (varcharResultSet, varcharColumnIndex) -> Slices.utf8Slice((String)varcharResultSet.getString(varcharColumnIndex)), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN));
            }
            case 2005: 
            case 2011: {
                return Optional.of(ColumnMapping.sliceMapping((Type)VarcharType.createUnboundedVarcharType(), (resultSet, columnIndex) -> Slices.utf8Slice((String)resultSet.getString(columnIndex)), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN));
            }
            case -3: 
            case 2004: {
                return Optional.of(ColumnMapping.sliceMapping((Type)VarbinaryType.VARBINARY, (resultSet, columnIndex) -> Slices.wrappedBuffer((byte[])resultSet.getBytes(columnIndex)), (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN));
            }
            case 93: {
                int timestampPrecision = typeHandle.requiredDecimalDigits();
                return Optional.of(OracleClient.oracleTimestampColumnMapping(TimestampType.createTimestampType((int)timestampPrecision)));
            }
            case -101: {
                return Optional.of(OracleClient.oracleTimestampWithTimeZoneColumnMapping());
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return OracleClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    private static ColumnMapping oracleTimestampColumnMapping(TimestampType timestampType) {
        if (timestampType.isShort()) {
            return ColumnMapping.longMapping((Type)timestampType, (LongReadFunction)OracleClient.oracleTimestampReadFunction(timestampType), (LongWriteFunction)OracleClient.oracleTimestampWriteFunction(timestampType), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN);
        }
        return ColumnMapping.objectMapping((Type)timestampType, (ObjectReadFunction)OracleClient.oracleLongTimestampReadFunction(timestampType), (ObjectWriteFunction)OracleClient.oracleLongTimestampWriteFunction(timestampType), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN);
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    public Optional<ParameterizedExpression> convertPredicate(ConnectorSession session, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.connectorExpressionRewriter.rewrite(session, expression, assignments);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("NUMBER"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> String.format("SELECT * FROM (%s) WHERE ROWNUM <= %s", sql, limit));
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        return joinCondition.getOperator() != JoinCondition.Operator.IS_DISTINCT_FROM;
    }

    public static LongWriteFunction trinoDateToOracleDateWriteFunction() {
        return new LongWriteFunction(){

            public String getBindExpression() {
                return "TO_DATE(?, 'SYYYY-MM-DD')";
            }

            public void set(PreparedStatement statement, int index, long value) throws SQLException {
                long utcMillis = TimeUnit.DAYS.toMillis(value);
                LocalDateTime date = LocalDateTime.from(Instant.ofEpochMilli(utcMillis).atZone(ZoneOffset.UTC));
                statement.setString(index, DATE_FORMATTER.format(date));
            }

            public void setNull(PreparedStatement statement, int index) throws SQLException {
                statement.setNull(index, 12);
            }
        };
    }

    private static LongWriteFunction trinoTimestampToOracleDateWriteFunction() {
        return new LongWriteFunction(){

            public String getBindExpression() {
                return "TO_DATE(?, 'SYYYY-MM-DD HH24:MI:SS')";
            }

            public void set(PreparedStatement statement, int index, long value) throws SQLException {
                long epochSecond = Math.floorDiv(value, 1000000);
                int microsOfSecond = Math.floorMod(value, 1000000);
                Verify.verify((microsOfSecond == 0 ? 1 : 0) != 0, (String)"Micros of second must be zero: '%s'", (long)value);
                LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(epochSecond, 0, ZoneOffset.UTC);
                statement.setString(index, TIMESTAMP_SECONDS_FORMATTER.format(localDateTime));
            }

            public void setNull(PreparedStatement statement, int index) throws SQLException {
                statement.setNull(index, 12);
            }
        };
    }

    private static ObjectWriteFunction oracleLongTimestampWriteFunction(TimestampType timestampType) {
        final int precision = timestampType.getPrecision();
        OracleClient.verifyLongTimestampPrecision(timestampType);
        return new ObjectWriteFunction(){

            public Class<?> getJavaType() {
                return LongTimestamp.class;
            }

            public void set(PreparedStatement statement, int index, Object value) throws SQLException {
                LocalDateTime timestamp = StandardColumnMappings.fromLongTrinoTimestamp((LongTimestamp)((LongTimestamp)value), (int)precision);
                statement.setString(index, TIMESTAMP_NANO_OPTIONAL_FORMATTER.format(timestamp));
            }

            public String getBindExpression() {
                return OracleClient.getOracleBindExpression(precision);
            }

            public void setNull(PreparedStatement statement, int index) throws SQLException {
                statement.setNull(index, 12);
            }
        };
    }

    private static LongWriteFunction oracleTimestampWriteFunction(final TimestampType timestampType) {
        return new LongWriteFunction(){

            public String getBindExpression() {
                return OracleClient.getOracleBindExpression(timestampType.getPrecision());
            }

            public void set(PreparedStatement statement, int index, long epochMicros) throws SQLException {
                LocalDateTime timestamp = StandardColumnMappings.fromTrinoTimestamp((long)epochMicros);
                statement.setString(index, TIMESTAMP_NANO_OPTIONAL_FORMATTER.format(timestamp));
            }

            public void setNull(PreparedStatement statement, int index) throws SQLException {
                statement.setNull(index, 12);
            }
        };
    }

    private static String getOracleBindExpression(int precision) {
        if (precision == 0) {
            return "TO_TIMESTAMP(?, 'SYYYY-MM-DD HH24:MI:SS')";
        }
        if (precision <= 2) {
            return "TO_TIMESTAMP(?, 'SYYYY-MM-DD HH24:MI:SS.FF')";
        }
        return String.format("TO_TIMESTAMP(?, 'SYYYY-MM-DD HH24:MI:SS.FF%d')", precision);
    }

    private static LongReadFunction oracleTimestampReadFunction(TimestampType timestampType) {
        return (resultSet, columnIndex) -> {
            LocalDateTime timestamp = resultSet.getObject(columnIndex, LocalDateTime.class);
            if (timestamp.getYear() <= 0) {
                timestamp = timestamp.minusYears(1L);
            }
            return StandardColumnMappings.toTrinoTimestamp((TimestampType)timestampType, (LocalDateTime)timestamp);
        };
    }

    private static ObjectReadFunction oracleLongTimestampReadFunction(TimestampType timestampType) {
        OracleClient.verifyLongTimestampPrecision(timestampType);
        return ObjectReadFunction.of(LongTimestamp.class, (resultSet, columnIndex) -> {
            LocalDateTime timestamp = resultSet.getObject(columnIndex, LocalDateTime.class);
            if (timestamp.getYear() <= 0) {
                timestamp = timestamp.minusYears(1L);
            }
            return StandardColumnMappings.toLongTrinoTimestamp((TimestampType)timestampType, (LocalDateTime)timestamp);
        });
    }

    private static void verifyLongTimestampPrecision(TimestampType timestampType) {
        int precision = timestampType.getPrecision();
        Preconditions.checkArgument((precision > 6 && precision <= 9 ? 1 : 0) != 0, (String)"Precision is out of range: %s", (int)precision);
    }

    public static ColumnMapping oracleTimestampWithTimeZoneColumnMapping() {
        return ColumnMapping.longMapping((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, (resultSet, columnIndex) -> {
            ZonedDateTime timestamp = resultSet.getObject(columnIndex, ZonedDateTime.class);
            return DateTimeEncoding.packDateTimeWithZone((long)timestamp.toInstant().toEpochMilli(), (String)timestamp.getZone().getId());
        }, (LongWriteFunction)OracleClient.oracleTimestampWithTimeZoneWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN);
    }

    public static LongWriteFunction oracleTimestampWithTimeZoneWriteFunction() {
        return LongWriteFunction.of((int)-101, (statement, index, encodedTimeWithZone) -> {
            Instant time = Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)encodedTimeWithZone));
            ZoneId zone = DateTimeEncoding.unpackZoneKey((long)encodedTimeWithZone).getZoneId();
            statement.setObject(index, time.atZone(zone));
        });
    }

    private static WriteMapping oracleBooleanWriteMapping() {
        return WriteMapping.booleanMapping((String)"number(1)", (BooleanWriteFunction)OracleClient.oracleBooleanWriteFunction());
    }

    private static BooleanWriteFunction oracleBooleanWriteFunction() {
        return BooleanWriteFunction.of((int)-6, (statement, index, value) -> statement.setInt(index, value ? 1 : 0));
    }

    public static LongWriteFunction oracleRealWriteFunction() {
        return LongWriteFunction.of((int)7, (statement, index, value) -> statement.unwrap(OraclePreparedStatement.class).setBinaryFloat(index, Float.intBitsToFloat(Math.toIntExact(value))));
    }

    public static DoubleWriteFunction oracleDoubleWriteFunction() {
        return DoubleWriteFunction.of((int)8, (statement, index, value) -> statement.unwrap(OraclePreparedStatement.class).setBinaryDouble(index, value));
    }

    private SliceWriteFunction oracleCharWriteFunction() {
        return SliceWriteFunction.of((int)-15, (statement, index, value) -> statement.unwrap(OraclePreparedStatement.class).setFixedCHAR(index, value.toStringUtf8()));
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() || varcharType.getBoundedLength() > 1000 ? "nclob" : "varchar2(" + varcharType.getBoundedLength() + " CHAR)";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            Object dataType = charType.getLength() > 500 ? "nclob" : "char(" + charType.getLength() + " CHAR)";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)this.oracleCharWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("number(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            if (type.equals((Object)TimestampType.TIMESTAMP_SECONDS)) {
                return WriteMapping.longMapping((String)"date", (LongWriteFunction)OracleClient.trinoTimestampToOracleDateWriteFunction());
            }
            int precision = Math.min(timestampType.getPrecision(), 9);
            String dataType = String.format("timestamp(%d)", precision);
            if (timestampType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)OracleClient.oracleTimestampWriteFunction(timestampType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)OracleClient.oracleLongTimestampWriteFunction(TimestampType.createTimestampType((int)precision)));
        }
        WriteMapping writeMapping = WRITE_MAPPINGS.get(type);
        if (writeMapping != null) {
            return writeMapping;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        String sql = String.format("COMMENT ON COLUMN %s.%s IS %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.quoted(column.getColumnName()), OracleClient.varcharLiteral((String)comment.orElse("")));
        this.execute(session, sql);
    }

    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    public void dropNotNullConstraint(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping a not null constraint");
    }
}

