/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import io.airlift.units.Duration;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.jdbc.datasource.OpenTelemetryDataSource;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.spi.connector.ConnectorSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;

public class OraclePoolConnectionFactory
implements ConnectionFactory {
    private final OpenTelemetryDataSource dataSource;

    public OraclePoolConnectionFactory(String connectionUrl, Properties connectionProperties, CredentialProvider credentialProvider, int connectionPoolMinSize, int connectionPoolMaxSize, Duration inactiveConnectionTimeout, OpenTelemetry openTelemetry) throws SQLException {
        PoolDataSource dataSource = PoolDataSourceFactory.getPoolDataSource();
        dataSource.setConnectionFactoryClassName(OracleDataSource.class.getName());
        dataSource.setURL(connectionUrl);
        dataSource.setInitialPoolSize(connectionPoolMinSize);
        dataSource.setMinPoolSize(connectionPoolMinSize);
        dataSource.setMaxPoolSize(connectionPoolMaxSize);
        dataSource.setValidateConnectionOnBorrow(true);
        dataSource.setConnectionProperties(connectionProperties);
        dataSource.setInactiveConnectionTimeout(Math.toIntExact(inactiveConnectionTimeout.roundTo(TimeUnit.SECONDS)));
        credentialProvider.getConnectionUser(Optional.empty()).ifPresent(user -> {
            try {
                dataSource.setUser(user);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        credentialProvider.getConnectionPassword(Optional.empty()).ifPresent(password -> {
            try {
                dataSource.setPassword(password);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        this.dataSource = new OpenTelemetryDataSource((DataSource)dataSource, openTelemetry);
    }

    public Connection openConnection(ConnectorSession session) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(true);
        return connection;
    }
}

